# -*- coding: utf-8 -*-

from sandbox.sandboxsdk import errors as se
from sandbox.sandboxsdk import parameters as sp
from sandbox.sandboxsdk.channel import channel
from sandbox.sandboxsdk import process

from sandbox.projects.RunScript import RunScript

import os
import logging


class RunPythonScript(RunScript):
    '''
    Run arbitrary python script by specified python/virtualenv with specified resource as argument
    '''

    type = 'RUN_PYTHON_SCRIPT'

    class VenvResourceType(sp.SandboxStringParameter):
        name = 'venv_resource_type'
        description = 'virtual env resource type if you want last released resource'

    class VenvResource(sp.ResourceSelector):
        name = 'venv_resource'
        description = 'virtual env resource (leave empty if specify type)'

    input_parameters = [VenvResourceType,
                        VenvResource] + RunScript.input_parameters

    def get_cmdline(self, scriptdir):
        resid = self.ctx[self.VenvResource.name]
        if not resid:
            rtype = self.ctx[self.VenvResourceType.name]
            if rtype:
                rlist = channel.sandbox.list_resources(resource_type=rtype,
                                                        omit_failed=True,
                                                        all_attrs={'released': 'stable'},
                                                        limit=1,
                                                        arch=self.client_info['arch'],
                                                        order_by='-id')
                if not len(rlist):
                    raise se.SandboxTaskFailureError("Didn't find any stable-released resource of type %s" % rtype)
                resid = rlist[0]

        python = 'python'
        if resid:
            pytar = self.sync_resource(resid)
            if os.access(pytar, os.X_OK):
                logging.info('Resource is executable, using it as interpreter')
                python = pytar
            else:
                logging.info('Unpacking virtualenv resource')
                pydir = self.path('venv')
                os.makedirs(pydir)
                process.run_process(['tar', '-xaf', pytar], work_dir=pydir)
                python = '%s/bin/python' % pydir
                if not os.path.exists(python):
                    python = '%s/python' % pydir

        logging.info('Using python: %s' % python)

        return '%s %s' % (python, RunScript.get_cmdline(self, scriptdir))


__Task__ = RunPythonScript
