import os
import sys

import sandbox.common.types.client as ctc
import sandbox.common.types.misc as ctm

import sandbox.sandboxsdk.parameters as parameters
import sandbox.sandboxsdk.environments as environments
import sandbox.sandboxsdk.process as process

import sandbox.projects.common.build.ArcadiaTask as arcadia_task


class WikiParserBinary(parameters.ResourceSelector):
    name = 'wiki_parser_binary'
    description = 'wiki_parser binary'
    required = True


class MapreduceYtBinary(parameters.ResourceSelector):
    name = 'mapreduece_yt_binary'
    description = 'mapreduce-yt binary'
    required = True


class DestinationTablesPrefix(parameters.SandboxStringParameter):
    name = 'destination_tables_prefix'
    description = 'destination tables prefix'
    required = True


class VaultYtToken(parameters.SandboxStringParameter):
    name = 'yt_token'
    description = 'vault item (owner:name)'
    required = True


class YtPool(parameters.SandboxStringParameter):
    name = 'yt_pool'
    description = 'YT pool'
    required = False


class RunUpdateWikipedia(arcadia_task.ArcadiaTask):
    type = "RUN_UPDATE_WIKIPEDIA"

    dns = ctm.DnsType.DNS64

    environment = [
        environments.SvnEnvironment(),
        environments.PipEnvironment('yandex-yt')
    ]

    client_tags = ctc.Tag.Group.LINUX
    input_parameters = [
        parameters.SandboxArcadiaUrlParameter,
        DestinationTablesPrefix,
        MapreduceYtBinary,
        WikiParserBinary,
        VaultYtToken,
        YtPool,
    ]

    def __init__(self, *args, **kwargs):
        arcadia_task.ArcadiaTask.__init__(self, *args, **kwargs)

    def on_execute(self):
        wiki_parser_bin = self.sync_resource(self.ctx.get(WikiParserBinary.name))
        mapreduce_yt_bin = self.sync_resource(self.ctx.get(MapreduceYtBinary.name))

        arc_dir = self.get_arcadia_src_dir()
        script_path = os.path.join(arc_dir, "update_wikipedia_yt.sh")

        owner, name = self.ctx.get(VaultYtToken.name).split(':')
        os.environ['YT_TOKEN'] = self.get_vault_data(owner, name)
        os.environ['YT_POOL'] = self.ctx.get(YtPool.name)

        process.run_process(
            [script_path, sys.executable, self.ctx.get(DestinationTablesPrefix.name), wiki_parser_bin, mapreduce_yt_bin],
            log_prefix='update_wikipedia',
            outputs_to_one_file=False,
            shell=True,
        )


__Task__ = RunUpdateWikipedia
