# -*- coding: utf-8 -*-

from sandbox import sdk2
from sandbox.projects.common.nanny import nanny
# from sandbox.projects.sandbox import remote_copy_resource
from sandbox.projects.sandbox import http_upload_2
# from sandbox.projects.SO import resource_types


class UploadSoModelsBundle(http_upload_2.HTTPUpload2):
    name = 'UPLOAD_SO_MODELS_BUNDLE'
    service_id = 'spdaemon-in'
    comment = 'Autorelease'
    resource_type = 'SO_MACHINE_LEARNING_MODELS_SET'

    def on_prepare(self):
        self.Parameters.resource_type = self.resource_type

    def on_release(self, additional_parameters):
        nanny.ReleaseToNannyTask2.on_release(self, additional_parameters)
        oauth_token = sdk2.Vault.data("robot_mailspam_nanny_oauth_token")
        nanny_client = nanny.NannyClient(api_url='http://nanny.yandex-team.ru/',
                                         oauth_token=oauth_token)
        if self.service_id:
            nanny_client.update_service_sandbox_resources(
                service_id=self.service_id,
                task_type=self.type,
                task_id=str(self.id),
                deploy=True,
                comment="{0} of {1}: {2}".format(self.comment, self.name, self.Parameters.description)
                )
        sdk2.Task.on_release(self, additional_parameters)

    def mark_released_resources(self, status, ttl):
        super(UploadSoModelsBundle, self).mark_released_resources(status, ttl)


# class UploadSoModelsBundleResource(remote_copy_resource.RemoteCopyResource, nanny.ReleaseToNannyTask):
#
#    type = 'UPLOAD_SO_MODELS_BUNDLE_RESOURCE'
#
#    def on_release(self, additional_parameters):
#        nanny.ReleaseToNannyTask.on_release(self, additional_parameters)
#
#    def get_targets(self):
#        return [self.ctx['resource_type'].arcadia_build_path]
#
#    def get_resources(self):
#        return {
#            self.ctx['resource_type'].name: {
#                'description': self.ctx['resource_type'].name,
#                'resource_type': self.ctx['resource_type'],
#                'resource_path': os.path.basename(self.ctx['resource_type'].arcadia_build_path),
#            }
#        }
