# coding: utf-8

from sandbox import sdk2

default_releasers = [
    'robot-mailspam',
    'luckybug',
    'klimiky',
    'sgeorge',
    'dpotapov'
]


class SO_THEME_CLASSIFIER_BIN(sdk2.Resource):
    """
        binary file
    """
    ttl = 'inf'
    calc_md5 = True
    any_arch = False
    releasable = True
    releasers = default_releasers


class SO_THEME_CLASSIFIER_BUNDLE(sdk2.Resource):
    """
        w2v, themes, mlp
    """
    ttl = 'inf'
    calc_md5 = True
    any_arch = False
    releasable = True
    releasers = default_releasers


class SO_SPAM_DETECTOR_VW(sdk2.Resource):
    """
        ресурс одной модели VW
    """
    ttl = 'inf'
    calc_md5 = True
    any_arch = False
    releasable = True
    releasers = default_releasers


class SO_SPAM_DETECTOR_VW_BUNDLE(sdk2.Resource):
    """
        набор файлов моделей VW с их описанием
    """
    ttl = 'inf'
    calc_md5 = True
    any_arch = False
    releasable = True
    releasers = default_releasers


class SO_SPAM_DETECTOR_VW_BUNDLE_IN(SO_SPAM_DETECTOR_VW_BUNDLE):
    """
        набор файлов моделей VW для входящей почты с их описанием
    """
    route = 'in'


class SO_SPAM_DETECTOR_VW_BUNDLE_OUT(SO_SPAM_DETECTOR_VW_BUNDLE):
    """
        набор файлов моделей VW для исходящей почты с их описанием
    """
    route = 'out'


class SO_SPAM_DETECTOR_VW_BUNDLE_CORP(SO_SPAM_DETECTOR_VW_BUNDLE):
    """
        набор файлов моделей VW для корпоративной почты с их описанием
    """
    route = 'corp'


class SO_SPAM_DETECTOR_DSSM(sdk2.Resource):
    """
        ресурс одной модели DSSM
    """
    ttl = 'inf'
    calc_md5 = True
    any_arch = False
    releasable = True
    releasers = default_releasers


class SO_SPAM_DETECTOR_DSSM_BUNDLE(sdk2.Resource):
    """
        набор файлов моделей DSSM с их описанием
    """
    ttl = 'inf'
    calc_md5 = True
    any_arch = False
    releasable = True
    releasers = default_releasers


class SO_SPAM_DETECTOR_DSSM_BUNDLE_IN(SO_SPAM_DETECTOR_DSSM_BUNDLE):
    """
        набор файлов моделей DSSM для входящей почты с их описанием
    """
    route = 'in'


class SO_SPAM_DETECTOR_DSSM_BUNDLE_OUT(SO_SPAM_DETECTOR_DSSM_BUNDLE):
    """
        набор файлов моделей DSSM для исходящей почты с их описанием
    """
    route = 'out'


class SO_SPAM_DETECTOR_DSSM_BUNDLE_CORP(SO_SPAM_DETECTOR_DSSM_BUNDLE):
    """
        набор файлов моделей DSSM для корпоративной почты с их описанием
    """
    route = 'corp'


class SO_SENDER_REPUTATION_BIN(sdk2.Resource):
    """
        sender reputation binary
    """
    ttl = 'inf'
    calc_md5 = True
    any_arch = False
    releasable = True
    releasers = default_releasers


class SO_MACHINE_LEARNING_MODEL(sdk2.Resource):
    """
        файл модели MN
    """
    ttl = 'inf'
    calc_md5 = True
    any_arch = False
    releasable = True
    releasers = default_releasers


class SO_MACHINE_LEARNING_MODELS_SET(sdk2.Resource):
    """
        набор моделей для демона СО
    """
    ttl = 'inf'
    calc_md5 = True
    any_arch = False
    releasable = True
    releasers = default_releasers


class SO_MACHINE_LEARNING_FRODO(sdk2.Resource):
    """
        файлы моделей Фродообороны
    """
    ttl = 'inf'
    calc_md5 = True
    any_arch = False
    releasable = True
    releasers = default_releasers


class SO_GENERAL_SHINGLER_BIN(sdk2.Resource):
    """
        general shingler binary
    """
    ttl = 'inf'
    calc_md5 = True
    any_arch = False
    releasable = True
    releasers = default_releasers


class SO_RULES_READER(sdk2.Resource):
    """
        ckecking rules reader's binary
    """
    ttl = 'inf'
    calc_md5 = True
    any_arch = False
    releasable = True
    releasers = default_releasers


class SO_IN_RULES_BUNDLE(sdk2.Resource):
    """
        файлы правил сервиса проверки входящей почты
    """
    ttl = 'inf'
    calc_md5 = True
    any_arch = False
    releasable = True
    releasers = default_releasers


class SO_OUT_RULES_BUNDLE(sdk2.Resource):
    """
        файлы правил сервиса проверки исходящей почты
    """
    ttl = 'inf'
    calc_md5 = True
    any_arch = False
    releasable = True
    releasers = default_releasers


class SO_CORP_RULES_BUNDLE(sdk2.Resource):
    """
        файлы правил сервиса проверки корп. почты
    """
    ttl = 'inf'
    calc_md5 = True
    any_arch = False
    releasable = True
    releasers = default_releasers


class SO_SEARCH_RULES_BUNDLE(sdk2.Resource):
    """
        файлы правил сервиса проверки поиска по почте
    """
    ttl = 'inf'
    calc_md5 = True
    any_arch = False
    releasable = True
    releasers = default_releasers


class SO_PASSPORT_RULES_BUNDLE(sdk2.Resource):
    """
        файлы правил сервиса проверки регистраций в Паспорте
    """
    ttl = 'inf'
    calc_md5 = True
    any_arch = False
    releasable = True
    releasers = default_releasers


class SO_CHECKFORM_RULES_BUNDLE(sdk2.Resource):
    """
        файлы правил сервиса проверки форм
    """
    ttl = 'inf'
    calc_md5 = True
    any_arch = False
    releasable = True
    releasers = default_releasers


class SO_CHECKMESSAGES_RULES_BUNDLE(sdk2.Resource):
    """
        файлы правил сервиса проверки коротких сообщений
    """
    ttl = 'inf'
    calc_md5 = True
    any_arch = False
    releasable = True
    releasers = default_releasers


class SO_STATIP_RULES_BUNDLE(sdk2.Resource):
    """
        файлы правил сервиса репутаций IP-адресов (Спамстат)
    """
    ttl = 'inf'
    calc_md5 = True
    any_arch = False
    releasable = True
    releasers = default_releasers


class SO_TEST_IN_RULES_BUNDLE(sdk2.Resource):
    """
        файлы тестовой версии правил сервиса тестинга проверки входящей почты
    """
    ttl = 'inf'
    calc_md5 = True
    any_arch = False
    releasable = True
    releasers = default_releasers


class SO_TEST_OUT_RULES_BUNDLE(sdk2.Resource):
    """
        файлы тестовой версии правил сервиса тестинга проверки исходящей почты
    """
    ttl = 'inf'
    calc_md5 = True
    any_arch = False
    releasable = True
    releasers = default_releasers


class SO_TEST_CORP_RULES_BUNDLE(sdk2.Resource):
    """
        файлы тестовой версии правил сервиса тестинга проверки корпоративной почты
    """
    ttl = 'inf'
    calc_md5 = True
    any_arch = False
    releasable = True
    releasers = default_releasers


class SO_ANTIFRAUD_RULES_BUNDLE(sdk2.Resource):
    """
        файлы правил антифрода
    """
    ttl = 'inf'
    calc_md5 = True
    any_arch = False
    releasable = True
    releasers = default_releasers


class SO_RBL_CSA_WHITELIST(sdk2.Resource):
    """
        CSA whitelist для RBL
    """
    calc_md5 = True
    any_arch = True
    releasable = True


class SO_RBL_SPAMCOP(sdk2.Resource):
    """
       spamcop blacklist для RBL
    """
    calc_md5 = True
    any_arch = True
    releasable = True


class SO_RBL_SPAMSOURCE(sdk2.Resource):
    """
        Снэпшот базы спамстата для RBL
    """
    calc_md5 = True
    any_arch = True
    releasable = True


class SO_TEXT_DEOBFUSCATOR_LANGUAGE(sdk2.Resource):
    """
        набор файлов описывающий один язык для TTextDeobduscator
    """
    releasers = [
        "pardus",
        "dskor",
        "krabchuk",
        "kamoksin"
    ]
    ttl = 'inf'
    releasable = True
    any_arch = False


class SO_IN_RULES_DICT(sdk2.Resource):
    """
        словарь правил сервиса проверки входящей почты
    """
    ttl = 'inf'
    calc_md5 = True
    any_arch = False
    releasable = True
    releasers = default_releasers


class SO_OUT_RULES_DICT(sdk2.Resource):
    """
        словарь правил сервиса проверки исходящей почты
    """
    ttl = 'inf'
    calc_md5 = True
    any_arch = False
    releasable = True
    releasers = default_releasers


class SO_CORP_RULES_DICT(sdk2.Resource):
    """
        словарь правил сервиса проверки корп. почты
    """
    ttl = 'inf'
    calc_md5 = True
    any_arch = False
    releasable = True
    releasers = default_releasers


class SO_USER_FEATURES_BIN(sdk2.Resource):
    """
        бинарь с юзерскими фичами
    """
    ttl = 'inf'
    calc_md5 = True
    any_arch = False
    releasable = True
    releasers = default_releasers + ["krabchuk"]


class SO_GREY_COMPLAINAINTS_LIST(sdk2.Resource):
    """
        список "серых жалобщиков" (SODEV-2121)
    """
    releasers = [
        "robot-mlp-conveyor",
        "krabchuk",
        "sgeorge",
        "klimiky",
        "luckybug",
        "dpotapov",
    ]
    ttl = 'inf'
    releasable = True
    any_arch = False


class SO_FRAUD_TANKER_OVERDRAFT_UIDS(sdk2.Resource):
    """
        ресурс со списком уидов с овердрафтом
    """
    ttl = 7
    calc_md5 = True
    any_arch = True
    releasable = True
    releasers = default_releasers + ['robot-mlp-overdraft', 'krabchuk']


class SO_FRAUD_PRESTABLE_REQUESTS(sdk2.Resource):
    """
        ресурс с запросами из ытя
    """
    ttl = 7
    calc_md5 = True
    any_arch = True
    releasable = True
    releasers = default_releasers + ["kkutikov"]


class SO_FRAUD_CURRENCIES_RATE_MAP(sdk2.Resource):
    """
        ресурс с таблицей валют из ытя
    """
    ttl = 7
    calc_md5 = True
    any_arch = True
    releasable = True
    releasers = default_releasers


class SO_BUNKER_FPAY_CONFIG(sdk2.Resource):
    """
        ресурс с конфигом familypay из бункера
    """
    ttl = 7
    calc_md5 = True
    any_arch = True
    releasable = True
    releasers = default_releasers


class SO_TANKER_FPAY_PUSH_TEMPLATE(sdk2.Resource):
    """
        ресурс с переводами пушей семейной оплаты
    """
    ttl = 7
    calc_md5 = True
    any_arch = True
    releasable = True
    releasers = default_releasers
