# -*- coding: utf-8 -*-
from __future__ import absolute_import, unicode_literals

try:
    from analyze_params_for_tokens import YtTokensExposedInParams
except ImportError:
    from .analyze_params_for_tokens import YtTokensExposedInParams

import yt.wrapper as yt
import logging

logging.basicConfig(level=logging.INFO)
logger = logging.getLogger(__name__)


def prepare_secrets():
    import os
    return os.environ["YT_TOKEN"], os.environ["HEC_TOKEN"]


# Read tables from paths(list) and return dict with key equal to filename and value equal to 20 rows
def table_reader(token, paths, rows_count=None, cluster="hahn", table_format=yt.YsonFormat()):
    yt.config["token"] = token
    proxy = cluster + ".yt.yandex.net"
    yt.config["proxy"]["url"] = proxy
    result = dict()
    if rows_count is None:
        rows_count = 30

    for path in paths:
        filename = path.split("/")[-1]
        table = yt.read_table(path, table_format)
        table = list(table)
        table = table[-rows_count:]
        result[filename] = table
    return result


def send_to_splunk(hec_token, result_tables):
    from hec_sender import SplunkHECSender

    for filename, data in result_tables.items():
        source = filename
        logger.info("Calling splunk sender with source %s ...", source)
        sender = SplunkHECSender(token=hec_token, source=source)
        sender.send_data(data)


def main():
    logger.info("Preparing secrets ...")
    yt_token, hec_token = prepare_secrets()
    # Prepare objects
    analyze = YtTokensExposedInParams(token=yt_token)

    # Prepare enrich table
    logger.info("Running analysis ...")
    result = analyze.run_analysis()

    if result:
        result_table = table_reader(yt_token, [result])
        send_to_splunk(hec_token, result_table)


if __name__ == "__main__":
    main()
