from sandbox import sdk2
from sandbox.sandboxsdk import environments
from sandbox.sdk2.helpers import subprocess
import logging
import os
import sys


class YtProxyAnalyzeCopy(sdk2.Task):
    class Requirements(sdk2.Task.Requirements):
        environments = (
            environments.PipEnvironment("yandex-yt"),
            environments.PipEnvironment("yandex-yt-yson-bindings-skynet"),
        )

    def on_execute(self):
        os.environ["YT_TOKEN"] = sdk2.Vault.data(self.owner, "AuditYtLogs")
        os.environ["HEC_TOKEN"] = sdk2.Vault.data(self.owner, "AuditYtLogsHEC")

        file_path = os.path.join(os.path.abspath(os.path.dirname(__file__)),
                                 "main.py")

        with sdk2.helpers.ProcessLog(self, logger=logging.getLogger("main")) as pl:
            return_code = subprocess.Popen([sys.executable, file_path],
                                           stdout=pl.stdout, stderr=subprocess.STDOUT).wait()

            if return_code == 0:
                logging.info("Subprocess ended successfully")
            else:
                logging.error("Subprocess ended with error: %s", return_code)
                raise Exception("Subprocess failed!")
