# -*- coding: utf-8 -*-
from __future__ import absolute_import, unicode_literals

try:
    from enrich import YtLogsEnrich
except:
    from .enrich import YtLogsEnrich

import yt.wrapper as yt
import logging

logging.basicConfig(level=logging.INFO)
logger = logging.getLogger(__name__)


def prepare_secrets():
    import os
    return os.environ["YT_TOKEN"], os.environ["HEC_TOKEN"]


# Read tables from paths(list) and return dict with key equal to filename and value equal to 20 rows
def table_reader(token, paths, rows_count=None, cluster="hahn", table_format=yt.YsonFormat()):
    yt.config["token"] = token
    proxy = cluster + ".yt.yandex.net"
    yt.config["proxy"]["url"] = proxy
    result = dict()
    if rows_count is None:
        rows_count = 30

    for path in paths:
        filename = path.split("/")[-1]
        table = yt.read_table(path, table_format)
        table = list(table)
        table = table[-rows_count:]
        result[filename] = table
    return result


def send_to_splunk(hec_token, result_tables):
    from hec_sender import SplunkHECSender

    for filename, data in result_tables.items():
        source = filename
        logger.info("Calling splunk sender with source %s ...", source)
        sender = SplunkHECSender(token=hec_token, source=source)
        sender.send_data(data)


def main():
    logger.info("Preparing secrets ...")
    yt_token, hec_token = prepare_secrets()
    # Prepare objects
    enrich = YtLogsEnrich(token=yt_token)

    # Prepare enrich table
    logger.info("Starting enrichment of logs ...")
    enrich.enrich_yt_proxy_log()


if __name__ == "__main__":
    main()
