# -*- coding: utf-8 -*-
from __future__ import absolute_import, unicode_literals
import yt.wrapper as yt
from datetime import datetime, date, timedelta
import logging

logger = logging.getLogger(__name__)


# This is base Class
class YtWorker(object):
    def __init__(self, token, cluster="hahn", source_table=None, source_path="//logs/yt-proxy-http-application-log/1d/",
                 dest_path="//home/infrasec/yt/"):
        # Config yt parameters
        self.yt = yt
        self.cluster = cluster
        self.proxy = cluster + ".yt.yandex.net"
        self.yt.config["token"] = token
        self.yt.config["proxy"]["url"] = self.proxy
        self.yt.config["auto_merge_output"]["action"] = "merge"
        # Filters for compability
        self.yt.config['pickling']['module_filter'] = lambda module: hasattr(module, '__file__') and \
            not module.__file__.endswith('.so') and \
            'hashlib' not in getattr(module, '__name__', '') and \
            'hmac' not in getattr(module, '__name__', '')

        self.yt.config['pickling']['force_using_py_instead_of_pyc'] = True
        # Tunning maximum resource usage
        self.yt_spec = {"job_io": {"table_writer": {"max_row_weight": 128 * 1024 * 1024}}}

        # Get date methods
        def _get_current_date():
            today = date.today().strftime("%Y-%m-%d")
            return today

        def _get_yesterday_date():
            yesterday = (date.today() - timedelta(1)).strftime("%Y-%m-%d")
            return yesterday

        self.today = _get_current_date()
        self.yesterday = _get_yesterday_date()
        self.current_datetime = datetime.now()

        # Define paths: source -- path YT logs in logbroker, dest -- path to our account storage
        if source_table is None:
            self.source_table = source_path + self.yesterday
            self.dest_path = dest_path + self.yesterday
        elif source_table is not None and isinstance(source_table, unicode):
            try:
                datetime.strptime(source_table, "%Y-%m-%d")
                self.source_table = source_path + source_table
                self.dest_path = dest_path + source_table
            except ValueError:
                logger.error("datetime.strptime failed with %s as source table", source_table)
                raise Exception("Invalid source table format! Required format: %Y-%m-%d")
        elif not isinstance(source_table, unicode):
            logger.error("Source table type: %s", type(source_table))
            raise TypeError("Source table must be string.")

        logger.info("Source table: %s", self.source_table)
        logger.info("Dest path: %s", self.dest_path)

        # Define subfolders tree
        self.analysis_folder = self.dest_path + "/analysis"
        self.analysis_fails_stats = self.analysis_folder + "/fails-stats"
        self.analysis_user_activity = self.analysis_folder + "/user-activity"
        self.raw_master_folder = self.dest_path + "/raw-master"

        # Define path to enrichment table
        self.enrich_table = self.dest_path + "/yt_proxy_enrich"
        self.raw_master_enrich_table = self.raw_master_folder + "/raw_master_enrich"
