# coding: utf-8

from sandbox import sdk2
from sandbox.common.types import client as ctc
from sandbox.projects.security.common.task import SecurityBaseTask


class YtSecretsDigger(SecurityBaseTask):
    class Requirements(sdk2.Task.Requirements):
        client_tags = ctc.Tag.GENERIC | ctc.Tag.MULTISLOT
        disk_space = 1024
        ram = 4096
        cores = 8

    class SecurityOptions(SecurityBaseTask.SecurityOptions):
        subtask_resource_attrs = {
            "target": "security/soc/yt_secrets_digger"
        }

    class Parameters(sdk2.Task.Parameters):
#        verbose_mode = sdk2.parameters.Bool("Verbose mode", default=False)
#        id_mapping = sdk2.parameters.Bool("Old vuln IDs mappin", default=True)
#        email = sdk2.parameters.Bool("Send email notification with new vulns", default=True)

        with sdk2.parameters.RadioGroup("YT cluster") as env_type:
            env_type.values["Hahn"] = env_type.Value(value="Hahn", default=True)
            env_type.values["Hume"] = env_type.Value(value="Hume")

    def get_cmd(self, binary_path):
        cmd = [
            binary_path,
            "--cluster", self.Parameters.env_type,
        ]

#        if self.Parameters.verbose_mode:
#            cmd.append("--verbose")

        return cmd

    def get_additional_env(self):
        return {
	    "YT_TOKEN": sdk2.Vault.data("YT_TOKEN"),
	    "HEC_TOKEN": sdk2.Vault.data("HEC_TOKEN")
        }
