# -*- coding: utf-8 -*-

from sandbox.sandboxsdk.task import SandboxTask

from sandbox.sandboxsdk.parameters import SandboxBoolParameter, SandboxUrlParameter
from sandbox.sandboxsdk.parameters import SandboxStringParameter
from sandbox.sandboxsdk.parameters import SandboxSelectParameter

import json
import logging
import time
import urllib2

import xml.etree.ElementTree


class AlertsUrlParameter(SandboxUrlParameter):
    name = 'server_url'
    description = 'Url with alerts info'
    default_value = 'http://saas-mon.n.yandex-team.ru'


class DutyParameter(SandboxStringParameter):
    name, description = 'new_duty', 'Custom duty phone (leave it empty in common case)'
    default_value = ''


class DryRunParameter(SandboxBoolParameter):
    name, description = 'dry_run', 'Dry run'
    default_value = False


class DutyGroupParameter(SandboxSelectParameter):
    name, description = 'duty_group', 'Duty group, saas or fresh'
    choices = [
        ('saas', 'saas'),
        ('fresh', 'fresh')
    ]


SAAS_PHONES_MAP = {
    'alex0512': 66356,
    'anikella': 6087,
    'bvdvlg': 11753,
    'coffeeman': 56907,
    'derrior': 85107,
    'flyrise': 13975,
    'i024': 56595,
    'odinmillion': 47738,
    'saku': 7285,
    'salmin': 69713,
    'vbushev': 28067
}


class SaasAlertsManage(SandboxTask):
    type = 'SAAS_ALERTS_MANAGE'
    input_parameters = [DryRunParameter,
                        DutyGroupParameter,
                        DutyParameter
                        ]

    def get_url(self, url, retries=2):
        for i in range(retries):
            try:
                req = urllib2.urlopen(url).read()
                return req
            except Exception as e:
                self.set_info('error on getting url %s: %s' % (url, e))
        raise Exception('Cannot get url %s' % url)

    def get_duty_phone_old(self, token_name):
        calend_private_token = self.get_vault_data('RTYSERVER-ROBOT', token_name)
        url = 'https://calendar.yandex-team.ru/export/rss.xml?private_token=' + calend_private_token + '&limit=1'
        resp = urllib2.urlopen(url).read()
        xp = xml.etree.ElementTree.fromstring(resp)
        entry = [el for el in xp if el.tag.endswith('entry')][0]
        title = [el for el in entry if el.tag.endswith('title')][0]
        ttext = title.text
        logging.info('calendar entry title: ' + ttext)
        for login, phone in SAAS_PHONES_MAP.items():
            if login in ttext:
                logging.info('duty is %s, phone %s' % (login, phone))
                self.set_info('Current duty is %s@, phone %s' % (login, phone))
                return phone
        raise Exception('duty not found')

    def get_duty_phone(self, token_name):
        calend_private_token = self.get_vault_data('RTYSERVER-ROBOT', token_name)
        url = 'https://calendar.yandex-team.ru/export/html.xml?private_token=' + calend_private_token + '&limit=1' \
              + '&from=' + time.strftime('%Y-%m-%dT%H:%M:%S')
        resp = urllib2.urlopen(url).read()
        parts = resp.split('>')
        ttexts = [p for p in parts if 'Дежур' in p]
        if not ttexts:
            raise Exception('no duty entry: %s' % resp)
        ttext = ttexts[0]
        logging.info('calendar entry title: ' + ttext)
        for login, phone in SAAS_PHONES_MAP.items():
            if login in ttext:
                logging.info('duty is %s, phone %s' % (login, phone))
                self.set_info('Current duty is %s@, phone %s' % (login, phone))
                return phone
        raise Exception('duty not found')

    def set_phone(self, recipient_phone, robot_phone, token_telegpaph_name):
        url = 'https://telegraph.yandex-team.ru/api/v3/cucm/translation_pattern/pattern/' + robot_phone
        data = {'calledPartyTransformationMask': '55' + recipient_phone}
        token = self.get_vault_data('anikella', token_telegpaph_name)
        headers = {'Authorization': token if token.startswith('OAuth ') else ('OAuth ' + token),
                   'Content-Type': 'application/json'}
        logging.info('sending %s to %s' % (data, url))
        opener = urllib2.build_opener(urllib2.HTTPSHandler)
        req = urllib2.Request(url, data=json.dumps(data), headers=headers)
        req.get_method = lambda: 'PUT'
        if self.ctx.get(DryRunParameter.name):
            self.set_info('dry run, stopped before phone setting')
            return True
        try:
            resp = opener.open(req)
            ans = resp.read()
            logging.info('Ok: %s' % ans)
            return True
        except urllib2.HTTPError as e:
            ans = e.read()
            self.set_info('Error: ' + str(e.code) + ' ' + ans)
            return False
        except Exception as e:
            self.set_info('Error: %s' % e)
            return False

    def on_execute(self):
        group = self.ctx.get(DutyGroupParameter.name)
        if group == 'fresh':
            ROBOT_PHONE = '83877'
            TOKEN_CALENDAR_NAME = 'calendar_saas_fresh_duty'
            TOKEN_TELEGRAPH_NAME = 'telegraph_saas_fresh_duty'
            self.set_info('will set FRESH duty')
        elif group == 'saas':
            ROBOT_PHONE = '23590'
            TOKEN_CALENDAR_NAME = 'calendar_saas_duty'
            TOKEN_TELEGRAPH_NAME = 'telegraph_token'
            self.set_info('will set SAAS duty')
        else:
            raise Exception('internal error, unknown group %s' % group)

        if not int(ROBOT_PHONE):
            raise Exception('internal error, robot phone incorrect')

        new_duty = self.ctx.get(DutyParameter.name)
        if not new_duty:
            logging.info('getting duties from calendar')
            new_duty = self.get_duty_phone(TOKEN_CALENDAR_NAME)
        try:
            new_duty_phone = str(int(new_duty))
        except:
            raise Exception('incorrect new duty phone')
        success = self.set_phone(new_duty_phone, ROBOT_PHONE, TOKEN_TELEGRAPH_NAME)
        if not success:
            raise Exception('phone not set')


__Task__ = SaasAlertsManage
