# -*- coding: utf-8 -*-

import os

import sandbox.common.types.client as ctc

from sandbox.sandboxsdk import parameters
from sandbox.projects.common.build.ArcadiaTask import ArcadiaTask
from sandbox.projects.common.utils import svn_revision
# import sandbox.projects.common.build.parameters as build_params
import sandbox.projects.common.constants as consts
from sandbox.projects.common.arcadia import sdk

from sandbox.projects.PSUtil import print_folder_tree


class SanitizerBuild(ArcadiaTask):
    type = 'SANITIZER_BUILD'

    execution_space = 18000
    client_tags = ctc.Tag.LINUX_PRECISE

    class AdditionalParams(parameters.SandboxStringParameter):
        name = 'additional_params'
        description = 'Additional parameters'

    input_parameters = ArcadiaTask.input_parameters + [
        AdditionalParams,
    ]

    def initCtx(self):
        self.ctx['test_type'] = 'build'

    def on_execute(self):
        arcadia_src_dir = self.get_arcadia_src_dir()
        revision = svn_revision(arcadia_src_dir)
        self.set_info('arcadia\'s revision: ' + revision)

        build_system = consts.YMAKE_BUILD_SYSTEM
        release_dir = self.abs_path(self.LOCAL_RELEASE_DIR)
        build_type = consts.RELEASE_BUILD_TYPE
        target_dir = os.path.join('yweb', 'mail', 'wmiarc')
        resource_path = os.path.join(release_dir, target_dir)
        def_flags = self.ctx['additional_params'].strip()

        sdk.do_build(
            build_system, arcadia_src_dir, [target_dir], build_type, clear_build=True,
            results_dir=release_dir, def_flags=def_flags
        )

        print_folder_tree(self, self.abs_path(), recursive=True)
        print_folder_tree(self, release_dir, recursive=True)
        print_folder_tree(self, resource_path, recursive=True)

        self.create_resource(
            description=self.descr, resource_path=resource_path,
            resource_type='SANITIZER', attributes={'revision': revision, 'host': self.host}
        )

        self.set_info('Build completed at host ' + self.host)


__Task__ = SanitizerBuild
