from sandbox.projects.SecDis.data_types import Item, ItemType
from sandbox.projects.SecDis.Collectors import BaseCollector

from sandbox.projects.SecDis.Collectors.utils import Abc


class AbcCollector(BaseCollector):
    """ Service Security Discovery: persons/services by ABC service id collector task """
    collector_name = 'abc'
    input_types = (ItemType.SERVICE,)
    output_types = (ItemType.PERSON, ItemType.SERVICE,)

    def on_execute(self):
        abc_url = 'https://abc-back.yandex-team.ru/api/v4'
        access_token = self.get_vault('OAuthSecDis')

        abc = Abc(abc_url, access_token)

        item_list = [Item.unserialize(item) for item in self.Parameters.item_list]
        project_id = self.Parameters.project_id

        for item in item_list:
            abc_id = item.get_value()
            ancestor_id = item.get_id()
            persons_dict = dict()

            services_list = abc.get_service_by_id_with_descendants(abc_id)
            for service in services_list:
                new_item = Item(ItemType.SERVICE, project_id, service['id'], ancestor_id,
                                service.get('created_at'), service.get('modified_at'),
                                name=service['name'], slug=service['slug'])
                self.add_result(new_item, ancestor_id)

                persons_list = abc.get_service_members_by_id(service['id'])
                for person in persons_list:
                    login = person['person']['login']
                    if login not in persons_dict:
                        persons_dict[login] = person
                        persons_dict[login]['services'] = list()
                    if service['id'] not in persons_dict[login]['services']:
                        persons_dict[login]['services'].append(service['id'])

            for login, person in persons_dict.items():
                new_item = Item(ItemType.PERSON, project_id, login, ancestor_id,
                                person.get('created_at'), person.get('modified_at'),
                                name=person['person']['name'], is_dismissed=person['person']['is_dismissed'],
                                services=person['services'])
                self.add_result(new_item, ancestor_id)

        self.save_result()
