from sandbox.projects.SecDis.data_types import Item, ItemType
from sandbox.projects.SecDis.Collectors import BaseCollector

from sandbox.projects.SecDis.Collectors.utils import Abc


class AbcResourceCollector(BaseCollector):
    """ Service Security Discovery: resources by ABC services collector task """
    collector_name = 'abc_resource'
    input_types = (ItemType.SERVICE,)
    output_types = (ItemType.RESOURCE,)

    def get_abc_resources(self, item_list):
        project_id = self.Parameters.project_id
        abc_url = 'https://abc-back.yandex-team.ru/api/v4'
        access_token = self.get_vault('OAuthSecDis')

        resource_types = {
            21: 'host',
            22: 'vlan',
            23: 'fw',
            24: 'vs',
            29: 'domain',
        }

        abc = Abc(abc_url, access_token)

        for item in item_list:
            abc_id = item.get_value()
            ancestor_id = item.get_id()

            resources_list = abc.get_service_resources_by_id(abc_id, types=resource_types.keys())
            for resource in resources_list:
                type_id = resource['resource']['type']['id']
                if type_id not in resource_types.keys():
                    continue
                name = resource['resource']['name']
                state = resource['state']
                created_at = resource.get('created_at')
                updated_at = resource.get('modified_at')
                description = ''
                for attr in resource['resource']['attributes']:
                    if attr['name'] == 'description' and attr['value']:
                        description = attr['value']
                        break
                new_item = Item(ItemType.RESOURCE, project_id, name, ancestor_id, created_at, updated_at,
                                state=state, description=description, resource_type=resource_types[type_id])
                self.add_result(new_item, ancestor_id)

    def on_execute(self):
        service_list = [Item.unserialize(item) for item in self.Parameters.item_list if item['type'] == ItemType.SERVICE]
        self.get_abc_resources(service_list)

        self.save_result()
