from sandbox.sdk2.parameters import String, Integer
from sandbox.projects.SecDis.data_types import Item, ItemType
from sandbox.projects.SecDis.Collectors import BaseCollector
from sandbox.projects.SecDis.Collectors.utils import Conductor


class ConductorReleaseCollector(BaseCollector):
    """ Service Security Discovery: Conductor Release Collector """
    collector_name = 'conductor_release'
    input_types = ()
    output_types = (ItemType.RELEASE,)

    class Parameters(BaseCollector.Parameters):
        conductor_project_name = String("Conductor Project Name", required=True)
        conductor_branch = String("Conductor Branch", default="stable", required=False)
        conductor_limit = Integer("Conductor Limit", default=1000, required=False)

    def get_releases_for_project(self, project_name, branch='stable', limit=1000):
        conductor = Conductor()
        conductor_tasks_list = conductor.get_tasks_for_project(project_name=project_name, branch=branch, limit=limit)
        releases = []
        for conductor_task in conductor_tasks_list:
            for package in conductor_task['packages']:
                releases.append({'package': package, 'task': conductor_task})
        return releases

    def on_execute(self):
        project_id = self.Parameters.project_id
        conductor_project = self.Parameters.conductor_project_name
        branch = self.Parameters.conductor_branch
        limit = self.Parameters.conductor_limit

        releases_list = self.get_releases_for_project(project_name=conductor_project, branch=branch, limit=limit)
        for release in releases_list:
            if 'deploy_group' in release['task']:
                deploy_group = release['task']['deploy_group']
            else:
                deploy_group = ''
            new_item = Item(ItemType.RELEASE, project_id,
                            "%s %s" % (release['package']['package'], release['package']['version']), list(),
                            release['task']['done_at'], release['task']['done_at'],
                            release_name=release['package']['package'], release_version=release['package']['version'],
                            release_date=release['task']['done_at'], release_deploy_group=deploy_group,
                            release_ticket=release['task']['ticket']
                            )
            self.add_result(new_item, list())

        self.save_result()
