import os
from glob import glob
import xml.etree.ElementTree as ET

from sandbox.projects.SecDis.data_types import Item, ItemType


def _parse_fastcfi_cond_tpl(filename):
    result_handlers = []
    tree = ET.parse(open(filename, 'r')).getroot()
    for handlers in tree.findall("handlers"):
        for handler in handlers.findall("handler"):
            result_handlers.append({"uri": handler.get("url"), "filename": filename})
    return result_handlers


def parse_fastcgi_daemon_conf(folder, project_id, ancestor_id):
    file_list = [y for x in os.walk(folder) for y in glob(os.path.join(x[0], "fastcgi.conf.tpl"))]
    handlers = []
    for filename in file_list:
        filename_handlers = _parse_fastcfi_cond_tpl(filename)
        handlers += [Item(ItemType.HANDLE, project_id, h['uri'], ancestor_id,
                    path=filename[len(folder):]) for h in filename_handlers]
    return handlers
