import re
import os
import os.path

from sandbox.projects.SecDis.data_types import Item, ItemType

remote_true_re = re.compile(r'remote:\s+true')
create_resolver_re = re.compile(r'export\s+const\s+(\w+)\s+=\s+createResolver\s*\(', re.M)


def _get_resolvers(filename):
    resolvers = []
    with open(filename, 'r') as f:
        data = f.read()
    for match in create_resolver_re.finditer(data):
        resolver_name = match.group(1)
        cnt = 0
        end = 0
        for i, ch in enumerate(data[match.end():], match.end()):
            if ch == '(':
                cnt += 1
            elif ch == ')':
                if cnt == 0:
                    end = i
                    break
                cnt -= 1

        if end == 0:
            continue

        is_remote = False
        if remote_true_re.search(data[match.start():end + 1]) is not None:
            is_remote = True

        filename_split = filename.split('/')
        folder = filename_split[-2] + '/'
        if folder == 'resolvers/':
            folder = ''
        file = filename_split[-1][:-3]

        resolver = {
            'name': resolver_name,
            'pattern': folder + file + ':' + resolver_name,
            'method': 'POST',
            'remote': is_remote,
        }
        resolvers.append(resolver)

    return resolvers


def parse_node_resolver(folder, project_id, ancestor_id):
    files = []
    resolvers_folder = os.path.join(folder, 'src/resolvers')
    for root, dirnames, filenames in os.walk(resolvers_folder):
        for filename in filenames:
            filename_full = os.path.join(root, filename)
            if filename.endswith('.js'):
                files.append(filename_full)

    items = []
    for file in files:
        handles = _get_resolvers(file)
        items += [Item(ItemType.HANDLE, project_id, h['pattern'], ancestor_id,
                       path=file.split('work', 1)[-1], **h) for h in handles]

    return items
