import re
import os

from sandbox.projects.SecDis.data_types import Item, ItemType


def _process_block(block):
    name = re.search(r'name:\s+[\'\`](.+)[\'\`]', block)
    if name is None:
        return None
    name = name.groups()[0]

    pattern = re.search(r'pattern:\s+([\'\`].+[\'\`])', block)
    if pattern is None:
        return None
    pattern = pattern.groups()[0]

    method = re.search(r'method:\s+[\'](\w+)[\']', block)
    if method is None:
        method = ''
    else:
        method = method.groups()[0]

    res = {
        'name': name,
        'pattern': pattern,
        'method': method,
        'plain': block,
    }

    return res


def _get_routes(filename):
    with open(filename, 'r') as f:
        data = f.read()
    m = re.search(r'(?:var|const)\s+routes\s+=\s+\[', data)
    if m is None:
        return []

    data = data[m.end()-1:]
    braces = 0
    square_brackets = 0

    handles = []

    for i, ch in enumerate(data):
        if ch == '{':
            if braces == 0:
                block_start = i
            braces += 1
        elif ch == '}':
            braces -= 1
            if braces == 0:
                block = data[block_start:i + 1]
                res = _process_block(block)
                if res:
                    handles.append(res)
        elif ch == '[':
            square_brackets += 1
        elif ch == ']':
            square_brackets -= 1
        if square_brackets == 0:
            break

    return handles


def parse_nodejs(folder, project_id, ancestor_id):
    files = []
    for root, dirnames, filenames in os.walk(folder):
        for filename in filenames:
            filename_full = os.path.join(root, filename)
            if '/configs/route/' in filename_full and filename.endswith('.js'):
                files.append(filename_full)

    items = []
    for file in files:
        handles = _get_routes(file)
        items += [Item(ItemType.HANDLE, project_id, h['pattern'], ancestor_id,
                       path=file.split('work', 1)[-1], **h) for h in handles]

    return items
