import re
import os
from glob import glob

from sandbox.projects.SecDis.data_types import Item, ItemType


def _parse_php_symfony_route_annotation(filename):
    # /**
    # * @Route("ROUTE", methods={"GET", "POST"})
    # * @Method("GET")
    result_handlers = []
    comments = re.findall(r'/\*\*.+?\*/', open(filename).read(), re.DOTALL)
    for comment in comments:
        route = re.search(r'\@Route\(([\s\S]+?)\)', comment)
        if route:
            routes_args = [r.strip() for r in route.groups()[0].split(",")]
            route_name = routes_args[0].strip('"').strip("'")
            methods = []
            methods_args = re.search(r'methods={([\s\S]+?)}', route.groups()[0], re.DOTALL)
            if methods_args:
                methods = list(map(lambda method: method.strip().strip("\"'"), methods_args.groups()[0].split(",")))
            else:
                methods_annotation = re.search(r'\@Method\(([\s\S]+?)\)', comment)
                if methods_annotation:
                    methods_args = re.search(r'methods={([\s\S]+?)}', methods_annotation.groups()[0], re.DOTALL)
                    if methods_args:
                        methods = list(
                            map(lambda method: method.strip().strip("\"'"), methods_args.groups()[0].split(",")))
                    else:
                        methods_args_str = methods_annotation.groups()[0]
                        if methods_args_str.startswith("methods="):
                            methods_args_str = methods_args_str[len("methods="):]
                        methods_args_str = methods_args_str.strip("{}")
                        methods = list(
                            map(lambda method: method.strip().strip("\"'"), methods_args_str.split(",")))
            if methods:
                result_handlers.append({"uri": route_name, "filename": filename, "method": "/".join(set(methods))})
            else:
                result_handlers.append({"uri": route_name, "filename": filename, "method": "*"})
    return result_handlers


def parse_php_symfony_route_annotation(folder, project_id, ancestor_id):
    file_list = [y for x in os.walk(folder) for y in glob(os.path.join(x[0], "*.php"))]
    handlers = []
    for filename in file_list:
        filename_handlers = _parse_php_symfony_route_annotation(filename)
        handlers += [Item(ItemType.HANDLE, project_id, h['method'] + ' ' + h['uri'], ancestor_id,
                    path=filename[len(folder):], method=h['method']) for h in filename_handlers]
    return handlers
