import os
from glob import glob
from tokenize import generate_tokens
from token import tok_name

from sandbox.projects.SecDis.data_types import Item, ItemType


def _parse_python_aiohttp(filename):
    result_handlers = []
    tokens = filter(lambda t: tok_name[t[0]] in ["NAME", "OP", "STRING"], generate_tokens(open(filename).readline))
    for i in range(len(tokens)):
        if (tok_name[tokens[i][0]] == 'NAME' and tokens[i][1] == 'add_get') \
                and (tok_name[tokens[i + 1][0]] == 'OP' and tokens[i + 1][1] == '(') \
                and (tok_name[tokens[i + 2][0]] == 'STRING'):
            # router.add_get('route_string'
            path = tokens[i + 2][1][1:-1]
            result_handlers.append({"uri": path, "filename": filename, "method": "GET"})
        elif (tok_name[tokens[i][0]] == 'NAME' and tokens[i][1] == 'add_post') \
                and (tok_name[tokens[i + 1][0]] == 'OP' and tokens[i + 1][1] == '(') \
                and (tok_name[tokens[i + 2][0]] == 'STRING'):
            # router.add_post('route_string'
            path = tokens[i + 2][1][1:-1]
            result_handlers.append({"uri": path, "filename": filename, "method": "POST"})
        elif (tok_name[tokens[i][0]] == 'NAME' and tokens[i][1] == 'add_routes') \
                and (tok_name[tokens[i + 1][0]] == 'OP' and tokens[i + 1][1] == '(') \
                and (tok_name[tokens[i + 2][0]] == 'OP' and tokens[i + 2][1] == '['):
            j = i + 3
            while not (tok_name[tokens[j][0]] == 'OP' and tokens[j][1] == ']'):
                # web.get('rote_string'
                if (tok_name[tokens[j][0]] == 'NAME' and tokens[j][1] == 'web') \
                        and (tok_name[tokens[j + 1][0]] == 'OP' and tokens[j + 1][1] == '.') \
                        and (tok_name[tokens[j + 2][0]] == 'NAME' and tokens[j + 2][1] == 'get') \
                        and (tok_name[tokens[j + 3][0]] == 'OP' and tokens[j + 3][1] == '(') \
                        and (tok_name[tokens[j + 4][0]] == 'STRING'):
                    path = tokens[j + 4][1][1:-1]
                    result_handlers.append({"uri": path, "filename": filename, "method": "GET"})
                elif (tok_name[tokens[j][0]] == 'NAME' and tokens[j][1] == 'web') \
                        and (tok_name[tokens[j + 1][0]] == 'OP' and tokens[j + 1][1] == '.') \
                        and (tok_name[tokens[j + 2][0]] == 'NAME' and tokens[j + 2][1] == 'post') \
                        and (tok_name[tokens[j + 3][0]] == 'OP' and tokens[j + 3][1] == '(') \
                        and (tok_name[tokens[j + 4][0]] == 'STRING'):
                    path = tokens[j + 4][1][1:-1]
                    result_handlers.append({"uri": path, "filename": filename, "method": "POST"})
                j += 1
        elif (tok_name[tokens[i][0]] == 'OP' and tokens[i][1] == '@') \
            and (tok_name[tokens[i + 2][0]] == 'OP' and tokens[i + 2][1] == '.') \
            and (tok_name[tokens[i + 3][0]] == 'NAME'
                 and (tokens[i + 3][1] in ['get', 'post', 'put', 'delete', 'patch', 'head'])) \
            and (tok_name[tokens[i + 4][0]] == 'OP' and tokens[i + 4][1] == '(') \
            and (tok_name[tokens[i + 5][0]] == 'STRING'):
            # @ROUTES.get('ROUTE'
            # @ROUTES.post('ROUTE'
            path = tokens[i+5][1].strip("'")
            result_handlers.append({"uri": path, "filename": filename, "method": tokens[i + 3][1].upper()})
    return result_handlers


def parse_python_aiohttp(folder, project_id, ancestor_id):
    file_list = [y for x in os.walk(folder) for y in glob(os.path.join(x[0], "*.py"))]
    handlers = []
    for filename in file_list:
        filename_handlers = _parse_python_aiohttp(filename)
        handlers += [Item(ItemType.HANDLE, project_id, h['method'] + ' ' + h['uri'], ancestor_id,
                    path=filename[len(folder):], method=h['method']) for h in filename_handlers]
    return handlers
