import os
from glob import glob
from tokenize import generate_tokens
from token import tok_name

from sandbox.projects.SecDis.data_types import Item, ItemType


def _parse_python_django(filename):
    result_handlers = []
    tokens = filter(lambda t: tok_name[t[0]] in ["NAME", "OP", "STRING"], generate_tokens(open(filename).readline))
    for i in range(len(tokens)):
        # url.patterns('PREFIX', urls.url(r'ROUTE_REGEX',
        if (tok_name[tokens[i][0]] == "NAME" and tokens[i][1] == "urls") \
                and (tok_name[tokens[i + 1][0] == "OP"] and tokens[i + 1][1] == ".") \
                and (tok_name[tokens[i + 2][0] == "NAME"] and tokens[i + 2][1] == "patterns") \
                and (tok_name[tokens[i + 3][0] == "OP"] and tokens[i + 3][1] == "("):
            prefix = tokens[i + 4][1].strip("'") if tok_name[tokens[i + 4][0]] == "STRING" else ""
            url_token_pos = i + 5
            bracket_counter = 1  # counting open and closed brackets
            while url_token_pos < len(tokens) and bracket_counter > 0:
                if (tok_name[tokens[url_token_pos][0] == "OP"] and tokens[url_token_pos][1] == "("):
                    bracket_counter += 1
                elif (tok_name[tokens[url_token_pos][0] == "OP"] and tokens[url_token_pos][1] == ")"):
                    bracket_counter -= 1
                if (tok_name[tokens[url_token_pos][0]] == "NAME" and tokens[url_token_pos][1] == "urls") \
                    and (tok_name[tokens[url_token_pos + 1][0] == "OP"] and tokens[url_token_pos + 1][1] == ".") \
                    and (tok_name[tokens[url_token_pos + 2][0] == "NAME"] and tokens[url_token_pos + 2][1] == "url") \
                    and (tok_name[tokens[url_token_pos + 3][0] == "OP"] and tokens[url_token_pos + 3][1] == "(") \
                    and tok_name[tokens[url_token_pos + 4][0]] == "STRING":
                        result_handlers.append({"uri": prefix + "/" + tokens[url_token_pos + 4][1].lstrip("r").strip("'"),
                                                "filename": filename})
                url_token_pos += 1
    return result_handlers


def parse_python_django(folder, project_id, ancestor_id):
    file_list = [y for x in os.walk(folder) for y in glob(os.path.join(x[0], "*.py"))]
    handlers = []
    for filename in file_list:
        filename_handlers = _parse_python_django(filename)
        handlers += [Item(ItemType.HANDLE, project_id, h['uri'], ancestor_id,
                    path=filename[len(folder):]) for h in filename_handlers]
    return handlers
