import os
from glob import glob
from tokenize import generate_tokens
from token import tok_name

from sandbox.projects.SecDis.data_types import Item, ItemType


def _parse_python_twisted_methods_dict(filename):
    result_handlers = []
    tokens = filter(lambda t: tok_name[t[0]] in ["NAME", "OP", "STRING"], generate_tokens(open(filename).readline))
    for i in range(len(tokens)):
        # METHODS = { 'ROUTE':
        if (tok_name[tokens[i][0]] == "NAME" and tokens[i][1] == "METHODS") \
                and (tok_name[tokens[i + 1][0] == "OP"] and tokens[i + 1][1] == "=") \
                and (tok_name[tokens[i + 2][0] == "OP"] and tokens[i + 2][1] == "{"):
            url_token_pos = i + 3
            while url_token_pos < len(tokens) and tokens[url_token_pos][1] != "}":
                if tok_name[tokens[url_token_pos][0]] == "STRING" \
                    and (tok_name[tokens[url_token_pos + 1][0] == "OP"] and tokens[url_token_pos + 1][1] == ":"):
                        result_handlers.append({"uri": tokens[url_token_pos][1].strip("'"), "filename": filename})
                url_token_pos += 1
    return result_handlers


def parse_python_twisted_methods_dict(folder, project_id, ancestor_id):
    file_list = [y for x in os.walk(folder) for y in glob(os.path.join(x[0], "*.py"))]
    handlers = []
    for filename in file_list:
        filename_handlers = _parse_python_twisted_methods_dict(filename)
        handlers += [Item(ItemType.HANDLE, project_id, h['uri'], ancestor_id,
                    path=filename[len(folder):]) for h in filename_handlers]
    return handlers
