import re
import os

from sandbox.projects.SecDis.data_types import Item, ItemType

class_regex = re.compile(r'\@(Request|Get|Post)Mapping(\([\s\S]+?\))\n'
                         r'(?:\@\w+(?:\([\s\S]+?\))?\n)*'
                         r'public\s+class\s+.+?\{')
method_regex = re.compile(r'\@(Request|Get|Post)Mapping(\([\s\S]+?\))\n'
                          r'(?:\s*\@\w+(?:\([\s\S]+?\))?\n)*\s*'
                          r'public[\s\S]+?\)\s*(?:throws\s*\w+(?:\s*,\s*\w+)*)?\s*{')


def _parse_annotation(m):
    if m is None:
        return '', ''
    annotation = m.groups()[0]
    params = m.groups()[1]

    if annotation == 'Get':
        method = 'GET'
    elif annotation == 'Post':
        method = 'POST'
    else:
        method = ''

    m = re.search(r'method\s*=\s*(.*?)', params)
    if m:
        method = m.groups()[0]

    m = re.search(r'(?:value|path)\s*=\s*(.*?)[,\)]', params)
    if m:
        value = m.groups()[0]
    elif re.match(r'\(\"(.*?)\"\)', params):
        value = params[2:-2]
    else:
        value = ''

    value = value.replace('"', '').replace('\'', '')

    return method, value


def _get_handles(filename):
    handles = []
    with open(filename, 'r') as f:
        data = f.read()

    m = class_regex.search(data)
    base_method, base_handle = _parse_annotation(m)
    if base_handle.endswith('/'):
        base_handle = base_handle[:-1]

    if m:
        start = m.end()
    else:
        start = 0

    for m in method_regex.finditer(data[start:]):
        method, handle = _parse_annotation(m)
        if handle.startswith('/'):
            handle = handle[1:]
        if not method:
            method = base_method
        handle = base_handle + '/' + handle
        handles.append(dict(handle=handle, method=method))

    return handles


def parse_spring(folder, project_id, ancestor_id):
    items = []
    for root, dirnames, filenames in os.walk(folder):
        for filename in filenames:
            filename_full = os.path.join(root, filename)
            if filename.endswith('.java'):
                handles = _get_handles(filename_full)
                items += [Item(ItemType.HANDLE, project_id, h['handle'], ancestor_id,
                               path=filename_full.split('work', 1)[-1], **h) for h in handles]

    return items
