from sandbox.projects.SecDis.data_types import Item, ItemType
from sandbox.projects.SecDis.Collectors import BaseCollector

import logging
import sys, traceback
from time import sleep
from requests import get


class MacrosCollector(BaseCollector):
    """ Service Security Discovery: fw macroses by ABC services collector task """
    collector_name = 'abc_resource'
    input_types = (ItemType.SERVICE,)
    output_types = (ItemType.RESOURCE,)

    def get_macros_dict(self):
        access_token = self.get_vault('OAuthSecDis')
        headers = {
            'Authorization': 'OAuth {}'.format(access_token)
        }
        url = 'https://racktables.yandex-team.ru/export/network-macros-owners.php'

        res = get(url, headers=headers, verify=False)
        if res.status_code != 200:
            return None
        json_data = res.json()
        return json_data

    def macros_collector(self, abc_id):
        from yaseclib.abc import Abc
        from yaseclib.staff import Staff

        access_token = self.get_vault('OAuthSecDis')
        abc_url = 'https://abc-back.yandex-team.ru/api/v4/'
        staff_url = 'https://staff-api.yandex-team.ru/v3/'
        abc = Abc(abc_url, access_token)
        staff = Staff(staff_url, access_token)

        head_map = {
            905: 'grishakov',
            435: 'tigran',
            1415: 'dex',
        }
        head = head_map.get(abc_id)
        if head is None:
            return None

        subservices = [s['slug'] for s in abc.get_service_by_id_with_descendants(abc_id)]
        macros_dict = self.get_macros_dict()
        macroses = list()

        i = 0
        for macros, owners in macros_dict.items():
            if i % 100 == 0:
                logging.info('[macros_collector] processed {}/{}, found {}'.format(i, len(macros_dict), len(macroses)))
            i = i + 1
            owners = owners.get('owners', [])
            owners_length = len(owners)
            if not owners:
                continue

            try:
                weight = 0
                for owner in owners:
                    owner_type = owner.get('type', '')
                    owner_name = owner.get('name', '')

                    if (owner_type == 'service' or owner_type == 'servicerole') and owner_type.startswith('svc_'):
                        owner_name = owner_name[4:]

                    if owner_type == 'user':
                        if owner_name.startswith('robot-'):
                            owner_name = staff.get_robot_responsible(owner_name)
                            if owner_name is None:
                                continue
                        chief_list = staff.get_person_chief_list(owner_name)
                        if head in chief_list or owner_name == head:
                            weight += 1
                    elif owner_type == 'service':
                        if owner_name in subservices:
                            weight += 1
                    elif owner_type == 'department':
                        group_info = staff.get_group_info(owner_name, fields=['department.heads'])
                        if 'department' not in group_info or not group_info['department'].get('heads'):
                            owners_length = owners_length - 1
                            continue
                        department_head = group_info['department']['heads'][0]['person']['login']
                        chief_list = staff.get_person_chief_list(department_head)
                        if head in chief_list or department_head == head:
                            # weight += 1
                            macroses.append(macros)
                            break
                    elif owner_type == 'servicerole':
                        service_name, service_role = owner_name.split('_', 1)
                        if service_name in subservices:
                            weight += 1

                    if owners_length and 1.0 * weight / owners_length > 0.5:
                        macroses.append(macros)
                        break
            except:
                traceback.print_exc(file=sys.stdout)
                sleep(1)
        return macroses

    def on_execute(self):
        service_list = [Item.unserialize(item) for item in self.Parameters.item_list if item['type'] == ItemType.SERVICE]
        project_id = self.Parameters.project_id
        ancestor_id = service_list[0].get_id()
        abc_id = service_list[0].get_value()

        macroses = self.macros_collector(abc_id)
        if macroses is None:
            return
        for macros in macroses:
            new_item = Item(ItemType.RESOURCE, project_id, macros, ancestor_id, resource_type='fwmacros')
            self.add_result(new_item, ancestor_id)

        self.save_result()
