import logging

from sandbox.sdk2.helpers import ProcessLog
from sandbox.sdk2.ssh import Key
from sandbox.sdk2.helpers import subprocess as sp
from sandbox.sandboxsdk import svn

from sandbox.projects.SecDis.data_types import Item, ItemType
from sandbox.projects.SecDis.Collectors import CloneRepositoryCollector

class MicroserviceFromCodeCollector(CloneRepositoryCollector):
    """ Service Security Discovery: search microservices in source code """
    collector_name = 'handle'
    input_types = (ItemType.REPO,)
    output_types = (ItemType.REPO,ItemType.MICROSERVICE,)

    def on_execute(self):
        item_list = [Item.unserialize(item) for item in self.Parameters.item_list]

        for item in item_list:
            if item.get_type() == ItemType.REPO:
                folder = self.clone(item)
                if folder is None:
                    logging.error('Error while cloning repo %s', item.get_value())
                    continue

        self.save_result()
