from sandbox.projects.SecDis.data_types import Item, ItemType
from sandbox.projects.SecDis.Collectors import BaseCollector

from sandbox.projects.SecDis.Collectors.utils import Startrek, Dogma


class QueueCollector(BaseCollector):
    """ Service Security Discovery: Startrek queues by ABC service info collector task """
    collector_name = 'queue'
    input_types = (ItemType.PERSON, ItemType.SERVICE,)
    output_types = (ItemType.QUEUE,)

    @staticmethod
    def get_queue_members(queue, st, dogma):
        members = set()

        queue_components = st.get_queue_components(queue)
        for component in queue_components:
            lead = component['lead']['id']
            members.add(lead)

        last_commits = dogma.get_last_commits(queue, 100)
        for commit in last_commits:
            login = commit['commit']['author']['login']
            members.add(login)

        return list(members)

    def on_execute(self):
        st_url = 'https://st-api.yandex-team.ru/v2'
        dogma_url = 'https://dogma.yandex-team.ru/api/v3'
        access_token = self.get_vault('OAuthSecDis')

        st = Startrek(st_url, access_token)
        dogma = Dogma(dogma_url, access_token)

        item_list = [Item.unserialize(item) for item in self.Parameters.item_list]
        project_id = self.Parameters.project_id

        person_dict = dict()
        service_dict = dict()
        for item in item_list:
            if item.get_type() == ItemType.PERSON:
                person_dict[item.get_value()] = item.get_id()
            if item.get_type() == ItemType.SERVICE:
                service_dict[item.get_value()] = item.get_id()

        for q in st.get_queues():
            if 'service' in q:
                service_id = int(q['service']['id'])
                if service_id in service_dict:
                    ancestor_id = service_dict[service_id]
                    new_item = Item(ItemType.QUEUE, project_id, q['key'], ancestor_id, name=q['name'], lead=q['lead']['id'])
                    self.add_result(new_item, ancestor_id)
            elif q['lead']['id'] in person_dict:
                ancestor_id = person_dict[q['lead']['id']]
                members = self.get_queue_members(q['key'], st, dogma)
                if members and set(members).issubset(person_dict.keys()):
                    new_item = Item(ItemType.QUEUE, project_id, q['key'], ancestor_id, name=q['name'], lead=q['lead']['id'])
                    self.add_result(new_item, ancestor_id)

        self.save_result()
