import logging
from time import mktime, gmtime

from sandbox.projects.SecDis.data_types import Item, ItemType
from sandbox.projects.SecDis.Collectors import BaseCollector

from sandbox.projects.SecDis.Collectors.utils import Dogma


class RepoCollector(BaseCollector):
    """ Service Security Discovery: repositories by Startrek queue collector task """
    collector_name = 'repo'
    input_types = (ItemType.QUEUE,)
    output_types = (ItemType.REPO,)

    def on_execute(self):
        dogma_url = 'https://dogma.yandex-team.ru/api/v3'
        access_token = self.get_vault('OAuthSecDis')

        auxiliary = self.load_auxiliary()
        logging.info("auxiliary %s" % auxiliary)
        if auxiliary is None:
            auxiliary = dict()
        cur_ts = int(mktime(gmtime()))
        prev_ts = auxiliary.get('ts', cur_ts - 180*24*3600)
        prev_repos = auxiliary.get('repos', dict())

        ts = cur_ts
        repos = dict()

        d = Dogma(dogma_url, access_token)

        item_list = [Item.unserialize(item) for item in self.Parameters.item_list]
        project_id = self.Parameters.project_id

        for item in item_list:
            queue = item.get_value()
            ancestor_id = item.get_id()

            res = d.get_repositories_by_queue(queue, prev_ts)
            prev_res = prev_repos.get(queue, list())
            repos[queue] = list(set(res).union(prev_res))

            for repo in repos[queue]:
                new_item = Item(ItemType.REPO, project_id, repo, ancestor_id)
                self.add_result(new_item, ancestor_id)

            logging.info("Queue %s repositories %s" % (queue, repos[queue]))

        auxiliary = {
            'ts': ts,
            'repos': repos
        }
        self.save_auxiliary(auxiliary)

        self.save_result()
