# -*- coding: utf-8 -*-

import os.path
from sandbox.projects import resource_types
from sandbox.sandboxsdk.parameters import ResourceSelector
from sandbox.sandboxsdk.parameters import SandboxStringParameter

from sandbox.projects.common.middlesearch.evlogcachehit import TestMiddlesearchEvlogCachehit


class CachehitPlansParameter(ResourceSelector):
    name = 'middlesearch_cachehit_plans_resource_id'
    description = 'Cachehit plans:'
    resource_type = resource_types.MIDDLESEARCH_CACHEHIT_PLANS
    group = 'Query Options'


class PlanFileNameParameter(SandboxStringParameter):
    name = 'middlesearch_plan_filename'
    description = 'Plan filename'
    group = 'Query Options'


SHOOT_PARAMS = TestMiddlesearchEvlogCachehit.input_parameters + (CachehitPlansParameter,)
"""
    Основные параметры, которые могут применяться в запускающих задачах
"""


class ShootMetasearchWithPlan(TestMiddlesearchEvlogCachehit):
    """
        Измеряет кэшхит метапоиска. Умеет использовать уже готовый кеш запросов.
        https://wiki.yandex-team.ru/JandeksPoisk/KachestvoPoiska/Middlesearch/Cachehit
    """

    type = 'SHOOT_METASEARCH_WITH_PLAN'

    input_parameters = SHOOT_PARAMS + (PlanFileNameParameter,)

    def initCtx(self):
        self.execution_space = 120000
        self.ctx['kill_timeout'] = 14400

    def _get_plan_name(self):
        return self.ctx[PlanFileNameParameter.name]

    def _get_plan_path(self):
        plans_dir = self.sync_resource(self.ctx[CachehitPlansParameter.name])
        if self.ctx.get(PlanFileNameParameter.name):
            return os.path.join(plans_dir, self.ctx[PlanFileNameParameter.name])
        else:
            return plans_dir


__Task__ = ShootMetasearchWithPlan
