# -*- coding: utf-8 -*-
daily_query = '''
PRAGMA yt.DefaultMemoryLimit = "16G";
$search_type = ($model_found, $search_type) ->
{{
    RETURN IF($model_found is not NULL, "model", IF($search_type in AsList("offers-by-cbir", "offers-by-cbir-last", "offers-by-cbir-similar"),"cv","search"));
}};

$view_type = ($economy, $domain, $price, $from_button, $search_type) -> {{
    RETURN IF(
        String::Contains($domain,"avito") or String::Contains($domain,"youla"),
        "new",
        IF(
            $from_button = "1",
            "button",
            IF(
                $search_type in AsList("offers-by-cbir", "offers-by-cbir-last", "offers-by-cbir-similar"),
                "cv",
                IF(
                    $economy = "1",
                    "profit",
                    IF(
                        $price="0" or $price is NULL or LEN($price)=0,
                        "price_on_ym",
                        IF(
                            $economy="-1" or $economy="0",
                            "lowest",
                            ""
                        )
                    )
                )
            )
        )
    )
}};

$get_list = ($cats) -> {{RETURN String::SplitToList($cats, ",")}};
$get_bottom_category = ($cats) -> {{RETURN $get_list($cats)[ListLength($get_list($cats)) - 1]}};


$count=Re2::Count("/");


$cut_query = ($x) -> {{
    $st = Url::Parse($x);
    RETURN $st.Host || $st.Path;
}};

$split_url = ($url) -> {{
    RETURN String::SplitToList($cut_query($url),"/", true, true)
}};

$host_plus = ($url, $level) -> {{
    RETURN String::JoinFromList(ListTake($split_url($url),$level),"/" )
}};

$full_url = ($url) -> {{
    RETURN String::JoinFromList($split_url($url),"/" )
}};

PRAGMA FILE("dssm.model", "https://nirvana.yandex-team.ru/api/storedData/d43bafc1-7bf5-4ecf-afb6-32bec7136365/data");
$DSSM_model = Dssm::LoadModel(FilePath("dssm.model"));

INSERT INTO @table
with truncate
SELECT
    log.transaction_id as transaction_id,
    log.yandexuid as yandexuid,
    $cut_query(log.url) as url,
    redir.click as click,
    buy.cart as cart,
    log.price as price,
    log.most_relevant_offer_price as most_relevant_offer_price,
    log._other["offers_count"] as offers_count,
    log._other["is_mobile"] as is_mobile,
    log.economy as economy,
    log.domain as domain,
    log._other["from_button"] as from_button,
    log.search_type as search_type,
    log.model_name as model_name,
    log._other["category_path"] as category_path,
    Yson::ConvertToDoubleList(Yson::ParseJson(log.vision_relevances)) as relevance,
    log._other["offers_name"] as offers_name,
    log.query as query,
    log.breadcrumbs as breadcrumbs,
    log._other["classifier_category_name"] ?? log._other["redirector_category_name"] as classifier_category_name,
    log.filtered_query as filtered_query,
    log.most_relevant_offer_name as most_relevant_offer_name

FROM
    `{log_dir}/{log_table}` as log
    LEFT JOIN (
    SELECT transaction_id, COUNT_IF(_other["click_type"] is not NULL) as click
        FROM `{redir_dir}/{log_table}`
        GROUP BY transaction_id
    ) as redir ON (log.transaction_id=redir.transaction_id)
    LEFT JOIN (
        SELECT referral_transaction_id, COUNT_IF(event = "cart") as cart, COUNT_IF(event = "checkout") as buy
        FROM `{buy_dir}/{log_table}`
        GROUP BY referral_transaction_id
    ) as buy ON (log.transaction_id=buy.referral_transaction_id)
WHERE log._other["can_be_shown"] != "0";

COMMIT;

INSERT INTO @shows
with truncate
SELECT *
FROM @table SAMPLE {part_show}
WHERE click = 0 or click is null;

INSERT INTO @clicks
WITH TRUNCATE
SELECT *
FROM @table SAMPLE {part_click}
WHERE click > 0 and (cart is null or cart = 0);

INSERT INTO @carts
WITH TRUNCATE
SELECT *
FROM @table SAMPLE {part_cart}
WHERE  cart > 0;

COMMIT;

INSERT INTO @log
WITH TRUNCATE
SELECT
    DISTINCT yandexuid,
    transaction_id,
    url,
    click,
    cart,
    price,
    most_relevant_offer_price,
    offers_count,
    offers_name,
    query,
    is_mobile,
    economy,
    domain,
    from_button,
    search_type,
    model_name,
    category_path,
    relevance,
    breadcrumbs,
    classifier_category_name,
    filtered_query,
    most_relevant_offer_name
FROM
    CONCAT(@shows, @clicks, @carts);

COMMIT;

INSERT INTO `{result_dir}/daily/{result_table}`
WITH TRUNCATE
select
    log.transaction_id as transaction_id,
    CAST(log.click IS NOT NULL as Uint8) as click,
    log.cart ?? 0 as cart,
    CAST(log.price as Int32) ?? 0 as price,
    IF(CAST(log.price as Int32) == 0, 0, CAST(log.most_relevant_offer_price as Float)/CAST(log.price as Int32)) ?? 0 as reduction,
    CAST(log.offers_count as Int32) ?? 0 as offers_count,
    CAST(log.is_mobile as Uint8) ?? 0 as is_mobile,
    $full_url(log.url) as url,
    $count($full_url(log.url)) as url_size,
    log.query as query,
    log.offers_name as offers_name,
    log.breadcrumbs as breadcrumbs,
    log.classifier_category_name as classifier_category_name,
    log.filtered_query as filtered_query,
    log.most_relevant_offer_name as most_relevant_offer_name,
    Dssm::Apply($DSSM_model, AsStruct(log.query ?? "" AS query, log.url ?? "" AS doc_url, log.offers_name ?? "" AS doc_title, "" AS doc_uta_url, "213" as query_region,
String::JoinFromList(ListTake(ListSkip(String::SplitToList(log.url,"/", true, true), 1),1),"/" ) as doc_host, "" as doc_path), "joint_output_bigrams")[0] as dssm,
    Dssm::Apply($DSSM_model, AsStruct(log.filtered_query ?? "" AS query, log.url ?? "" AS doc_url, log.most_relevant_offer_name ?? "" AS doc_title, "" AS doc_uta_url, "213" as query_region,
String::JoinFromList(ListTake(ListSkip(String::SplitToList(log.url,"/", true, true), 1),1),"/" ) as doc_host, "" as doc_path), "joint_output_bigrams")[0] as dssm_most_relevant,
    Dssm::Apply($DSSM_model, AsStruct(log.breadcrumbs ?? "" AS query, log.url ?? "" AS doc_url, log.classifier_category_name ?? "" AS doc_title, "" AS doc_uta_url, "213" as query_region,
String::JoinFromList(ListTake(ListSkip(String::SplitToList(log.url,"/", true, true), 1),1),"/" ) as doc_host, "" as doc_path), "joint_output_bigrams")[0] as dssm_category,
    view_search.view_type as view_type,
    IF(view_search.search_type == "search",0,IF(view_search.search_type == "model",1,2)) as search_type_num,
    view_search.search_type  as search_type,
    view_search.clicks ?? 0 as view_search_clicks,
    view_search.shows ?? 0 as view_search_shows,
    view_search.ctr ?? 0 as view_search_ctr,
    host_cat.shows ?? 0 as host_cat_shows,
    host_cat.clicks ?? 0 as host_cat_clicks,
    host_cat.ctr ?? 0 as host_cat_ctr,
    host_cat.popup ?? 0 as host_cat_popup,
    host_cat.cart ?? 0 as host_cat_cart,
    host_cat.wrong_product ?? 0 as host_cat_wrong_product,
    host_cat.mobile_closed ?? 0 as host_cat_mobile_closed,
    host_cat.pricebar_close ?? 0 as host_cat_pricebar_close,
    host_cat.mobile_popup_hidden ?? 0 as host_cat_mobile_popup_hidden,
    CAST(bottom_category.bottom_category as Int32) as bottom_category,
    bottom_category.shows ?? 0 as bottom_category_shows,
    bottom_category.clicks ?? 0 as bottom_category_clicks,
    bottom_category.ctr ?? 0 as bottom_category_ctr,
    log.relevance[0] ?? -1 as relevance_top,
    log.relevance[ListLength(log.relevance)/2] ?? -1 as relevance_median,
    log.relevance[ListLength(log.relevance) - 1] ?? -1 as relevance_bottom,
    IF(log.relevance[0] is not NULL and log.relevance[ListLength(log.relevance)/2] is not NULL, log.relevance[ListLength(log.relevance)/2]/log.relevance[0], -1) as relevance_median_top,
    IF(log.relevance[0] is not NULL and log.relevance[ListLength(log.relevance) - 1] is not NULL, log.relevance[ListLength(log.relevance) - 1]/log.relevance[0], -1) as relevance_bottom_top,
    log.yandexuid as yauid,
    yauid.d7_shows ?? 0 as yauid_7d_shows,
    yauid.d7_clicks ?? 0 as yauid_7d_clicks,
    yauid.d7_ctr ?? 0 as yauid_7d_ctr,
    yauid.d7_popup ?? 0 as yauid_7d_popup,
    yauid.d7_cart ?? 0 as yauid_7d_cart,
    yauid.d7_wrong_product ?? 0 as yauid_7d_wrong_product,
    yauid.d7_mobile_closed ?? 0 as yauid_7d_mobile_closed,
    yauid.d7_pricebar_close ?? 0 as yauid_7d_pricebar_close,
    yauid.d7_mobile_popup_hidden ?? 0 as yauid_7d_mobile_popup_hidden,
    yauid.d90_shows ?? 0 as yauid_90d_shows,
    yauid.d90_clicks ?? 0 as yauid_90d_clicks,
    yauid.d90_ctr ?? 0 as yauid_90d_ctr,
    yauid.d90_popup ?? 0 as yauid_90d_popup,
    yauid.d90_cart ?? 0 as yauid_90d_cart,
    yauid.d90_wrong_product ?? 0 as yauid_90d_wrong_product,
    yauid.d90_mobile_closed ?? 0 as yauid_90d_mobile_closed,
    yauid.d90_pricebar_close ?? 0 as yauid_90d_pricebar_close,
    yauid.d90_mobile_popup_hidden ?? 0 as yauid_90d_mobile_popup_hidden,
    url.d7_shows ?? 0 as url_d7_shows,
    url.d7_clicks ?? 0 as url_d7_clicks,
    url.d7_ctr ?? 0 as url_d7_ctr,
    url.d7_popup ?? 0 as url_d7_popup,
    url.d7_cart ?? 0 as url_d7_cart,
    url.d7_wrong_product ?? 0 as url_d7_wrong_product,
    url.d7_mobile_closed ?? 0 as url_d7_mobile_closed,
    url.d7_pricebar_close ?? 0 as url_d7_pricebar_close,
    url.d7_mobile_popup_hidden ?? 0 as url_d7_mobile_popup_hidden,
    url.d90_shows ?? 0 as url_d90_shows,
    url.d90_clicks ?? 0 as url_d90_clicks,
    url.d90_ctr ?? 0 as url_d90_ctr,
    url.d90_popup ?? 0 as url_d90_popup,
    url.d90_cart ?? 0 as url_d90_cart,
    url.d90_wrong_product ?? 0 as url_d90_wrong_product,
    url.d90_mobile_closed ?? 0 as url_d90_mobile_closed,
    url.d90_pricebar_close ?? 0 as url_d90_pricebar_close,
    url.d90_mobile_popup_hidden ?? 0 as url_d90_mobile_popup_hidden,
{host_plus_select}
FROM
    @log as log
    LEFT JOIN `{view_search_table}` as view_search
        ON (view_search.view_type = $view_type(log.economy, log.domain, log.price, log.from_button, log.search_type)
            and view_search.search_type = $search_type(log.model_name, log.search_type))
    LEFT JOIN `{host_cat_table}` as host_cat
        ON (host_cat.bottom_category = $get_bottom_category(log.category_path)
            and host_cat.host = $host_plus(log.url, 1))

    LEFT JOIN `{bottom_table}` as bottom_category ON( $get_bottom_category(log.category_path) = bottom_category.bottom_category)
    LEFT JOIN (
        SELECT
            log.yandexuid as yandexuid,
            d7.shows ?? 0 as d7_shows,
            d7.clicks ?? 0 as d7_clicks,
            d7.ctr ?? 0 as d7_ctr,
            d7.popup ?? 0 as d7_popup,
            d7.cart ?? 0 as d7_cart,
            d7.wrong_product ?? 0 as d7_wrong_product,
            d7.mobile_closed ?? 0 as d7_mobile_closed,
            d7.pricebar_close ?? 0 as d7_pricebar_close,
            d7.mobile_popup_hidden ?? 0 as d7_mobile_popup_hidden,
            d90.shows ?? 0 as d90_shows,
            d90.clicks ?? 0 as d90_clicks,
            d90.ctr ?? 0 as d90_ctr,
            d90.popup ?? 0 as d90_popup,
            d90.cart ?? 0 as d90_cart,
            d90.wrong_product ?? 0 as d90_wrong_product,
            d90.mobile_closed ?? 0 as d90_mobile_closed,
            d90.pricebar_close ?? 0 as d90_pricebar_close,
            d90.mobile_popup_hidden ?? 0 as d90_mobile_popup_hidden
        FROM
            (
                select distinct yandexuid
                from @log
            ) as log
            LEFT JOIN `{yauid_dir}/7days/{yauid_table}` as d7 ON (log.yandexuid = d7.yandexuid)
            LEFT JOIN `{yauid_dir}/90days/{yauid_table}` as d90 ON (d7.yandexuid = d90.yandexuid)
    ) as yauid ON (yauid.yandexuid=log.yandexuid)
    LEFT JOIN (
        SELECT
            log.url as url,
            d7.shows ?? 0 as d7_shows,
            d7.clicks ?? 0 as d7_clicks,
            d7.ctr ?? 0 as d7_ctr,
            d7.popup ?? 0 as d7_popup,
            d7.cart ?? 0 as d7_cart,
            d7.wrong_product ?? 0 as d7_wrong_product,
            d7.mobile_closed ?? 0 as d7_mobile_closed,
            d7.pricebar_close ?? 0 as d7_pricebar_close,
            d7.mobile_popup_hidden ?? 0 as d7_mobile_popup_hidden,
            d90.shows ?? 0 as d90_shows,
            d90.clicks ?? 0 as d90_clicks,
            d90.ctr ?? 0 as d90_ctr,
            d90.popup ?? 0 as d90_popup,
            d90.cart ?? 0 as d90_cart,
            d90.wrong_product ?? 0 as d90_wrong_product,
            d90.mobile_closed ?? 0 as d90_mobile_closed,
            d90.pricebar_close ?? 0 as d90_pricebar_close,
            d90.mobile_popup_hidden ?? 0 as d90_mobile_popup_hidden
        FROM
            (
                select distinct url
                from (
                    select $full_url(url) as url from @log
                )
            ) as log
            LEFT JOIN `{url_dir}/7days/{url_table}` as d7 ON (log.url = d7.url)
            LEFT JOIN `{url_dir}/90days/{url_table}` as d90 ON (log.url = d90.url)
    ) as url ON (url.url=$full_url(log.url))
    {host_plus_from}
;
'''

host_plus_select = '''
    $host_plus(log.url, {level}) as host_{level},
    host_{level}.d7_shows ?? 0 as host_{level}_d7_shows,
    host_{level}.d7_clicks ?? 0 as host_{level}_d7_clicks,
    host_{level}.d7_ctr ?? 0 as host_{level}_d7_ctr,
    host_{level}.d7_popup ?? 0 as host_{level}_d7_popup,
    host_{level}.d7_cart ?? 0 as host_{level}_d7_cart,
    host_{level}.d7_wrong_product ?? 0 as host_{level}_d7_wrong_product,
    host_{level}.d7_mobile_closed ?? 0 as host_{level}_d7_mobile_closed,
    host_{level}.d7_pricebar_close ?? 0 as host_{level}_d7_pricebar_close,
    host_{level}.d7_mobile_popup_hidden ?? 0 as host_{level}_d7_mobile_popup_hidden,
    host_{level}.d90_shows ?? 0 as host_{level}_d90_shows,
    host_{level}.d90_clicks ?? 0 as host_{level}_d90_clicks,
    host_{level}.d90_ctr ?? 0 as host_{level}_d90_ctr,
    host_{level}.d90_popup ?? 0 as host_{level}_d90_popup,
    host_{level}.d90_cart ?? 0 as host_{level}_d90_cart,
    host_{level}.d90_wrong_product ?? 0 as host_{level}_d90_wrong_product,
    host_{level}.d90_mobile_closed ?? 0 as host_{level}_d90_mobile_closed,
    host_{level}.d90_pricebar_close ?? 0 as host_{level}_d90_pricebar_close,
    host_{level}.d90_mobile_popup_hidden ?? 0 as host_{level}_d90_mobile_popup_hidden,
'''

host_plus_from = '''
    LEFT JOIN (
    SELECT
        log.url as url,
        d7.shows ?? 0 as d7_shows,
        d7.clicks ?? 0 as d7_clicks,
        d7.ctr ?? 0 as d7_ctr,
        d7.popup ?? 0 as d7_popup,
        d7.cart ?? 0 as d7_cart,
        d7.wrong_product ?? 0 as d7_wrong_product,
        d7.mobile_closed ?? 0 as d7_mobile_closed,
        d7.pricebar_close ?? 0 as d7_pricebar_close,
        d7.mobile_popup_hidden ?? 0 as d7_mobile_popup_hidden,
        d90.shows ?? 0 as d90_shows,
        d90.clicks ?? 0 as d90_clicks,
        d90.ctr ?? 0 as d90_ctr,
        d90.popup ?? 0 as d90_popup,
        d90.cart ?? 0 as d90_cart,
        d90.wrong_product ?? 0 as d90_wrong_product,
        d90.mobile_closed ?? 0 as d90_mobile_closed,
        d90.pricebar_close ?? 0 as d90_pricebar_close,
        d90.mobile_popup_hidden ?? 0 as d90_mobile_popup_hidden
    FROM
        (
                select distinct url
                from (
                    select $host_plus(url, {level}) as url from @log
                )
            ) as log
        LEFT JOIN `{url_dir}/7days/{url_table}` as d7 ON (log.url = d7.url)
        LEFT JOIN `{url_dir}/90days/{url_table}` as d90 ON (log.url = d90.url)
) as host_{level} ON (host_{level}.url=$host_plus(log.url, {level}))
'''

final_query = '''
INSERT INTO `{result_dir}/final/{result_table}`
WITH TRUNCATE
SELECT *
FROM RANGE("{result_dir}/daily","{table_from}","{table_to}");
'''
