# -*- coding: utf-8 -*-
yauid_day_query = '''
INSERT INTO `{result_dir}/daily/{table}`
    WITH TRUNCATE
SELECT
    log.yandexuid as yandexuid,
    SUM(log.shows) ?? 0 as shows,
    SUM(redir.clicks) ?? 0 as clicks,
    SUM(redir.clicks) / CAST(SUM(log.shows) AS Double) ?? 0 as ctr,
    SUM(event.popup) ?? 0 as popup,
    SUM(event.wrong_product) ?? 0 as wrong_product,
    SUM(event.disable) ?? 0 as disable,
    SUM(event.pricebar_close) ?? 0 as pricebar_close,
    SUM(event.mobile_closed) ?? 0 as mobile_closed,
    SUM(event.mobile_popup_hidden) ?? 0 as mobile_popup_hidden,
    SUM(buy.cart) ?? 0 as cart,
    SUM(buy.buy) ?? 0 as buy
FROM
    (
        SELECT
            COUNT(*) as shows,
            SOME(yandexuid) as yandexuid,
            transaction_id
        FROM
            `{log_dir}/{table}`
        WHERE _other["can_be_shown"] != "0"
        GROUP BY transaction_id
    ) as log
    LEFT JOIN (
        SELECT
            COUNT_IF(_other["click_type"] IS NOT NULL ) as clicks,
            transaction_id
        FROM
            `{redir_dir}/{table}`
        GROUP BY transaction_id
    ) as redir ON (log.transaction_id = redir.transaction_id)
    LEFT JOIN (
        SELECT
            COUNT_IF(event="popup-shown") as popup,
            COUNT_IF(event="wrong_product") as wrong_product,
            COUNT_IF(event="disable") as disable,
            COUNT_IF(event="pricebar_close") as pricebar_close,
            COUNT_IF(event="mobile-closed") as mobile_closed,
            COUNT_IF(event="mobile-popup-hidden")  as mobile_popup_hidden,
            transaction_id
        FROM
            `{event_dir}/{table}`
        GROUP BY transaction_id
    ) as event ON (log.transaction_id = event.transaction_id)
    LEFT JOIN (
        SELECT
            (COUNT_IF(event == "cart") ?? 0) as cart,
            (COUNT_IF(event == "checkout") ?? 0) as buy,
            referral_transaction_id
        FROM
            `{buy_dir}/{table}`
        GROUP BY referral_transaction_id
    ) as buy ON log.transaction_id = buy.referral_transaction_id
    GROUP BY log.yandexuid
;
'''

url_day_query = '''

$cut_query = ($x) -> {{
    $st = Url::Parse($x);
    RETURN $st.Host || $st.Path;
}};

INSERT INTO `{result_dir}/daily/{table}`
    WITH TRUNCATE
SELECT
    log.url as full_url,
    ListUniq( AsList(
        String::JoinFromList(SOME(log.split_url),"/"),
        String::JoinFromList(ListTake(SOME(log.split_url),1),"/" ),
        String::JoinFromList(ListTake(SOME(log.split_url),2),"/" ),
        String::JoinFromList(ListTake(SOME(log.split_url),3),"/" ),
        String::JoinFromList(ListTake(SOME(log.split_url),4),"/" )
    )) as url,
    SUM(log.shows) ?? 0 as shows,
    SUM(redir.clicks) ?? 0 as clicks,
    SUM(redir.clicks) / CAST(SUM(log.shows) AS Double) ?? 0 as ctr,
    SUM(event.popup) ?? 0 as popup,
    SUM(event.wrong_product) ?? 0 as wrong_product,
    SUM(event.disable) ?? 0 as disable,
    SUM(event.pricebar_close) ?? 0 as pricebar_close,
    SUM(event.mobile_closed) ?? 0 as mobile_closed,
    SUM(event.mobile_popup_hidden) ?? 0 as mobile_popup_hidden,
    SUM(buy.cart) ?? 0 as cart,
    SUM(buy.buy) ?? 0 as buy
FROM
    (
        SELECT
            COUNT(*) as shows,
            $cut_query(SOME(url)) as url,
            String::SplitToList($cut_query(SOME(url)),"/", true, true) as split_url,
            transaction_id
        FROM
            `{log_dir}/{table}`
        WHERE _other["can_be_shown"] != "0"
        GROUP BY transaction_id
    ) as log
    LEFT JOIN (
        SELECT
            COUNT_IF(_other["click_type"] IS NOT NULL ) as clicks,
            transaction_id
        FROM
            `{redir_dir}/{table}`
        GROUP BY transaction_id
    ) as redir ON (log.transaction_id = redir.transaction_id)
    LEFT JOIN (
        SELECT
            COUNT_IF(event="popup-shown")  as popup,
            COUNT_IF(event="wrong_product") as wrong_product,
            COUNT_IF(event="disable") as disable,
            COUNT_IF(event="pricebar_close") as pricebar_close,
            COUNT_IF(event="mobile-closed") as mobile_closed,
            COUNT_IF(event="mobile-popup-hidden") as mobile_popup_hidden,
            transaction_id
        FROM
            `{event_dir}/{table}`
        GROUP BY transaction_id
    ) as event ON (log.transaction_id = event.transaction_id)
    LEFT JOIN (
        SELECT
            COUNT_IF(event == "cart") as cart,
            COUNT_IF(event == "checkout") as buy,
            referral_transaction_id
        FROM
            `{buy_dir}/{table}`
        GROUP BY referral_transaction_id
    ) as buy ON log.transaction_id = buy.referral_transaction_id
    GROUP BY log.url
;
'''


yauid_stat_query = '''
INSERT INTO `{result_dir}/{period}/{last_table}`
WITH TRUNCATE
SELECT
    yandexuid,
    clicks,
    shows,
    clicks / CAST(shows AS Double) as ctr,
    popup,
    wrong_product,
    disable,
    pricebar_close,
    mobile_closed,
    mobile_popup_hidden,
    cart,
    buy
FROM (
    SELECT
        yandexuid,
        SUM(clicks) as clicks,
        SUM(shows) as shows,
        SUM(popup) as popup,
        SUM(wrong_product) as wrong_product,
        SUM(disable) as disable,
        SUM(pricebar_close) as pricebar_close,
        SUM(mobile_closed) as mobile_closed,
        SUM(mobile_popup_hidden) as mobile_popup_hidden,
        SUM(cart) as cart,
        SUM(buy) as buy
    FROM RANGE("{result_dir}/daily","{first_table}","{last_table}")
    GROUP BY yandexuid
);
'''

url_stat_query = '''
$count = Re2::Count("/");

INSERT INTO `{result_dir}/{period}/{last_table}`
WITH TRUNCATE
SELECT
    url,
    $count(url) as level,
    SUM(clicks) as clicks,
    SUM(shows) as shows,
    SUM(clicks) / CAST(SUM(shows) AS Double) as ctr,
    SUM(popup) as popup,
    SUM(wrong_product) as wrong_product,
    SUM(disable) as disable,
    SUM(pricebar_close) as pricebar_close,
    SUM(mobile_closed) as mobile_closed,
    SUM(mobile_popup_hidden) as mobile_popup_hidden,
    SUM(cart) as cart,
    SUM(buy) as buy
FROM
    RANGE("{result_dir}/daily","{first_table}","{last_table}") FLATTEN LIST BY url
GROUP BY url;
'''

search_view_day_query = '''
PRAGMA ClassicDivision = "false";

$search_type = ($model_found, $search_type) ->
{{
    RETURN IF($model_found is not NULL, "model", IF($search_type in AsList("offers-by-cbir", "offers-by-cbir-last", "offers-by-cbir-similar"),"cv","search"));
}};

$view_type = ($economy, $domain, $price, $from_button, $search_type) -> {{
    RETURN IF(
        String::Contains($domain,"avito") or String::Contains($domain,"youla"),
        "new",
        IF(
            $from_button = "1",
            "button",
            IF(
                $search_type in AsList("offers-by-cbir", "offers-by-cbir-last", "offers-by-cbir-similar"),
                "cv",
                IF(
                    $economy = "1",
                    "profit",
                    IF(
                        $price="0" or $price is NULL or LEN($price)=0,
                        "price_on_ym",
                        IF(
                            $economy="-1" or $economy="0",
                            "lowest",
                            ""
                        )
                    )
                )
            )
        )
    )
}};

INSERT INTO `{result_dir}/daily/{table}`
WITH TRUNCATE

SELECT
    view_type,
    search_type,
    COUNT(*) as shows,
    COUNT(click) as clicks,
    COUNT(click) / COUNT(*) as ctr
FROM
    (
    SELECT
        $search_type(log.model_name, log.search_type) as search_type,
        $view_type(log.economy, log.domain, log.price, log._other["from_button"], log.search_type) as view_type,
        redir._other["click_type"] as click
    FROM
        `{log_dir}/{table}` as log
        LEFT JOIN `{redir_dir}/{table}` as redir USING (transaction_id)
    )
GROUP BY view_type, search_type;
'''

search_view_stat_query = '''
INSERT INTO `{result_dir}/search_view`
WITH TRUNCATE

SELECT
    view_type,
    search_type,
    SUM(shows) as shows,
    SUM(clicks) as clicks,
    CAST(SUM(clicks) as Float)/SUM(shows) as ctr
FROM
    RANGE("{result_dir}/daily","{first_table}","{last_table}")
GROUP BY view_type, search_type;
'''

cat_day_query = '''
PRAGMA ClassicDivision = "false";

$get_bottom_category = ($cats) -> {{RETURN ListReverse(String::SplitToList($cats, ","))[0]}};

INSERT INTO `{result_dir}/daily/{table}`
WITH TRUNCATE

SELECT
    bottom_category,
    COUNT(*) as shows,
    COUNT_IF(redir._other["click_type"] is not null) as clicks,
    COUNT_IF(redir._other["click_type"] is not null) / COUNT(*) as ctr
FROM
    `{log_dir}/{table}` as log
    LEFT JOIN `{redir_dir}/{table}` as redir USING (transaction_id)
GROUP BY $get_bottom_category(log._other["category_path"]) as bottom_category;
'''

cat_stat_query = '''
INSERT INTO `{result_dir}/category`
WITH TRUNCATE

SELECT
    bottom_category,
    SUM(shows) as shows,
    SUM(clicks) as clicks,
    CAST(SUM(clicks) as Float)/SUM(shows) as ctr
FROM
    RANGE("{result_dir}/daily","{first_table}","{last_table}")
GROUP BY bottom_category;
'''

host_cat_day_query = '''
PRAGMA ClassicDivision = "false";

$get_bottom_category = ($cats) -> {{RETURN ListReverse(String::SplitToList($cats, ","))[0]}};

INSERT INTO `{result_dir}/daily/{table}`
    WITH TRUNCATE
SELECT
    bottom_category,
    host,
    SUM(log.shows) ?? 0 as shows,
    SUM(redir.clicks) ?? 0 as clicks,
    SUM(redir.clicks) / SUM(log.shows) ?? 0 as ctr,
    SUM(event.popup) ?? 0 as popup,
    SUM(event.wrong_product) ?? 0 as wrong_product,
    SUM(event.disable) ?? 0 as disable,
    SUM(event.pricebar_close) ?? 0 as pricebar_close,
    SUM(event.mobile_closed) ?? 0 as mobile_closed,
    SUM(event.mobile_popup_hidden) ?? 0 as mobile_popup_hidden,
    SUM(buy.cart) ?? 0 as cart,
    SUM(buy.buy) ?? 0 as buy
FROM
    (
        SELECT
            COUNT(*) as shows,
            SOME(url) as url,
            ListSkip(String::SplitToList(SOME(url),"/", true, true), 1) as split_url,
            $get_bottom_category(SOME(_other["category_path"])) as bottom_category,
            transaction_id
        FROM
            `{log_dir}/{table}`
        WHERE _other["can_be_shown"] != "0"
        GROUP BY transaction_id
    ) as log
    LEFT JOIN (
        SELECT
            COUNT_IF(_other["click_type"] IS NOT NULL ) as clicks,
            transaction_id
        FROM
            `{redir_dir}/{table}`
        GROUP BY transaction_id
    ) as redir ON (log.transaction_id = redir.transaction_id)
    LEFT JOIN (
        SELECT
            COUNT_IF(event="popup-shown")  as popup,
            COUNT_IF(event="wrong_product") as wrong_product,
            COUNT_IF(event="disable") as disable,
            COUNT_IF(event="pricebar_close") as pricebar_close,
            COUNT_IF(event="mobile-closed") as mobile_closed,
            COUNT_IF(event="mobile-popup-hidden") as mobile_popup_hidden,
            transaction_id
        FROM
            `{event_dir}/{table}`
        GROUP BY transaction_id
    ) as event ON (log.transaction_id = event.transaction_id)
    LEFT JOIN (
        SELECT
            COUNT_IF(event == "cart") as cart,
            COUNT_IF(event == "checkout") as buy,
            referral_transaction_id
        FROM
            `{buy_dir}/{table}`
        GROUP BY referral_transaction_id
    ) as buy ON log.transaction_id = buy.referral_transaction_id
    GROUP BY String::JoinFromList(ListTake(log.split_url,1),"/" ) as host, log.bottom_category as bottom_category
;

'''

host_cat_stat_query = '''
INSERT INTO `{result_dir}/host_category`
WITH TRUNCATE

SELECT
    host,
    bottom_category,
    SUM(shows) as shows,
    SUM(clicks) as clicks,
    CAST(SUM(clicks) as Float)/SUM(shows) as ctr,
    SUM(popup) as popup,
    SUM(wrong_product) as wrong_product,
    SUM(disable) as disable,
    SUM(pricebar_close) as pricebar_close,
    SUM(mobile_closed) as mobile_closed,
    SUM(mobile_popup_hidden) as mobile_popup_hidden,
    SUM(cart) as cart,
    SUM(buy) as buy
FROM
    RANGE("{result_dir}/daily","{first_table}","{last_table}")
GROUP BY host, bottom_category;
'''

url_to_SaaS = '''
insert into `{to_SaaS_dir}/url_{period}`
with truncate
select
    url AS doc_url,
 {fields}
FROM `{stat_dir}/{period}/{table}` WHERE LENGTH(url) < 3000 and level != 1 and level != 4 and url != "" and url is not null;
'''

yauid_to_SaaS = '''
insert into `{to_SaaS_dir}/yandexuid`
with truncate
SELECT
    d90.yandexuid ?? d7.yandexuid AS doc_url,
    {fields}
FROM `{stat_dir}/90days/{table}` as d90
    FULL JOIN  `{stat_dir}/7days/{table}` as d7
    USING (yandexuid)
WHERE d90.yandexuid IS NOT NULL AND d90.yandexuid != "";
'''

search_view_to_SaaS = '''
INSERT INTO `{to_SaaS_dir}/search_view`
WITH TRUNCATE

SELECT
    search_type || ";" || view_type AS doc_url,
    {fields}
FROM `{stat_dir}/search_view`;
'''

cat_to_SaaS = '''
INSERT INTO `{to_SaaS_dir}/category`
WITH TRUNCATE

SELECT
    bottom_category ?? "0" AS doc_url,
    {fields}
FROM `{stat_dir}/category` where bottom_category != "";
'''

host_cat_to_SaaS = '''
INSERT INTO `{to_SaaS_dir}/host_category`
WITH TRUNCATE

SELECT
    host || ";" || (bottom_category ?? "0") AS doc_url,
    {fields}
FROM `{stat_dir}/host_category` where bottom_category != "";
'''
