# coding: utf-8

import os
import tarfile
import logging

from sandbox import sdk2

from sandbox.projects.common.nanny import nanny

from sandbox.projects.Sovetnik.SovetnikBuild import SovetnikBuild
from sandbox.projects.Sovetnik.SovetnikResource import SovetnikResource

from sandbox.sdk2.helpers import subprocess as sp


class SovetnikMLServiceOldPackage(SovetnikResource):
    """ A resource that contains tar.gz package with files for Sovetnik's landings service. """
    ttl = 5


class SovetnikBuildMLServicePackage(nanny.ReleaseToNannyTask2, SovetnikBuild):
    pkg_name = 'sovetnik-ml.tar.gz'

    def get_path_to_pkg(self):
        """ Returns path to package. """
        if self.pkg_name is None:
            raise AttributeError('Package name is not defined')

        return str(self.path(self.pkg_name))

    def build(self):
        """
        Builds Sovetnik's package.

        :returns: Nothing.
        """

        path_to_work_dir = self.get_path_to_work_dir()
        logging.debug("Start build: {}".format(path_to_work_dir))

        if not os.path.exists(path_to_work_dir):
            os.makedirs(path_to_work_dir)

        with sdk2.helpers.ProcessLog(self, logger='build') as pl:
            sp.check_call(['touch', 'init.py'], cwd=path_to_work_dir,
                          stdout=pl.stdout, stderr=pl.stderr)

    def pack(self):
        """
        Creates package of working directory.

        :returns: Nothing.
        """
        path_to_pkg = self.get_path_to_pkg()
        path_to_work_dir = self.get_path_to_work_dir()

        logging.debug('path to package: {}'.format(path_to_pkg))
        logging.debug('path to working directory: {}'.format(path_to_work_dir))

        with tarfile.open(path_to_pkg, 'w:gz') as tar:
            for entry in os.listdir(path_to_work_dir):
                name = os.path.join(path_to_work_dir, entry)
                arcname = 'sovetnik-ml-service/{}'.format(entry)

                tar.add(name, arcname)

    def create_resource(self):
        path = self.get_path_to_pkg()
        description = "Sovetnik's ML service package"

        resource = SovetnikMLServiceOldPackage(
            self,
            path=path,
            description=description,
        )

        sdk2.ResourceData(resource).ready()

    def on_execute(self):
        with self.memoize_stage.build(commit_on_entrance=False):
            self.build()

        with self.memoize_stage.pack(commit_on_entrance=False):
            self.pack()

        with self.memoize_stage.create_resource(commit_on_entrance=False):
            self.create_resource()
