import os
import logging
import sandbox.common.types.misc as ctm

from sandbox import sdk2

from sandbox.projects.Sovetnik.SovetnikBuild import SovetnikBuild
from sandbox.projects.Sovetnik.SovetnikResource import SovetnikScript, SovetnikScriptTypes

NODE_MODULES_CACHING_SCRIPT = 'create-node-modules-resource.py'


class SovetnikBuildScriptsPackage(SovetnikBuild):

    class Requirements(sdk2.Task.Requirements):
        cores = 4
        ram = 4 * 1024
        disk_space = 4 * 1024
        dns = ctm.DnsType.DNS64

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(sdk2.Task.Parameters):
        with sdk2.parameters.Group('Git parameters') as git_parameters:
            git_release_branch = sdk2.parameters.String(
                label='Release branch',
                required=True,
                default='master',
            )
            git_ssh_url = sdk2.parameters.Url(
                label='Git remote SSH URL',
                required=True,
                default='git@github.yandex-team.ru:sovetnik/scripts.git',
            )

        with sdk2.parameters.Group('SSH parameters') as ssh_parameters:
            ssh_vault_owner = sdk2.parameters.String(
                label="Vault owner of Sovetnik's SSH private key",
                required=True,
                default='SOVETNIK',
            )
            ssh_vault_name = sdk2.parameters.String(
                label="Vault name of Sovetnik's SSH private key",
                required=True,
                default='robot-sovetnik-ssh',
            )
        with sdk2.parameters.RadioGroup('Scripts to put into resource') as scripts:
            build_node_modules = sdk2.parameters.Bool('Build node modules script', default=False)

    def create_resource(self):
        """
        Creates SOVETNIK_SCRIPTS resource.

        :returns: Nothing.
        """
        logging.debug('Creating sovetnik-scripts resource')
        path_to_work_dir = self.get_path_to_work_dir()

        if self.Parameters.build_node_modules:
            path = os.path.join(path_to_work_dir, SovetnikScriptTypes.NODE_MODULES_CACHE,
                                NODE_MODULES_CACHING_SCRIPT)
            resource = SovetnikScript(
                self,
                path=path,
                script_type=SovetnikScriptTypes.NODE_MODULES_CACHE,
                description="Sovetnik scripts package",
            )

            sdk2.ResourceData(resource).ready()

    def on_execute(self):
        logging.debug("Start Building SovetnikBuildScripts")

        with self.memoize_stage.clone_git_repository(commit_on_entrance=False):
            self.clone_git_repository()

        with self.memoize_stage.create_resource(commit_on_entrance=False):
            self.create_resource()

        logging.debug("End  Building SovetnikBuildScripts")
