import urllib

import logging
import requests


def create_conductor_ticket(task, conductor_auth, binary_packages, version, server_url, branch='testing', changelog=None):
    CONDUCTOR_URL = "http://c.yandex-team.ru"
    if not binary_packages:
        raise ValueError("Empty package list")
    if changelog:
        while len(urllib.urlencode({'comment': changelog})) > 7000:
            changelog = changelog[:-200]
            changelog = '{}\n...has been cut because too long\n'.format(changelog)
        insert_comment = '{}\n'.format(changelog)
    else:
        insert_comment = ''
    comment = "{}Created by {}/task/{}".format(insert_comment, server_url, task.id)
    query_args = [("ticket[branch]", branch), ("ticket[comment]", comment)]
    for idx, package in enumerate(binary_packages):
        query_args.append(("package[{0}]".format(idx), package))
        query_args.append(("version[{0}]".format(idx), version))
    query_url = "{0}/auth_update/ticket_add?{1}".format(CONDUCTOR_URL, urllib.urlencode(query_args, True))
    headers = {"Authorization": "OAuth {}".format(conductor_auth)}
    request = requests.get(query_url, headers=headers)
    logging.debug('#########')
    logging.debug('conductor response')
    logging.debug(request.text)
    request.raise_for_status()
    return request.text
