import logging

import requests


class Dist(object):
    """
    A class with some methods for working with dist.yandex.ru

    Attributes:
        repo_url(str, optional): repo url. Defaults to http://dist.yandex.ru
    """

    def __init__(self, repo_url='http://dist.yandex.ru'):
        self.__url = repo_url

    def find_package(self, binary_package, version=None, repo=None):
        """
        Find packages on dist

        :param binary_package: package name
        :param version: package version(optional)
        :param repo: repository(optional)
        :return: dict with results(optional)
        """
        if not binary_package:
            raise ValueError('Empty package name')

        req_url = '{}/find?'.format(self.__url)
        params = {'pkg': binary_package, 'repo': repo, 'ver': version, 'strict': 'True'}
        logging.info('Request {req_url} with params {params}'.format(req_url=req_url, params=params))
        req = requests.get(req_url, params=params)
        if req.status_code == 200:
            return req.json().get('result')

    def if_exist(self, binary_package, version, repo):
        """
        Check if package exist

        :param binary_package: package name
        :param version: package version
        :param repo: repository
        :return: boolean
        """
        results = self.find_package(binary_package, version, repo)
        if not results:
            return False
        for result in results:
            if (result.get('version') == version) & (result.get('repository') == repo):
                for deb in result.get('debs'):
                    if binary_package == deb.get('package'):
                        return True
