# coding: utf-8

from sandbox import sdk2

# Robots
robot_sovetnik = ['robot-sovetnik']
robot_market_infra = ['robot-market-infra']  # It's used to release tasks

# People
sovetnik = [
    'gahara',
    'vkozelsky',
    'danillewin',
    'kochet',
    'vladimirlevin',
    'bogdansky',
    "timsv",
    "yarovaya",
    "longlom"
]


class SovetnikResource(sdk2.Resource):
    """ Common ancestor for all Sovetnik's resources. """
    releasable = True
    auto_backup = True
    releasers = robot_market_infra + robot_sovetnik + sovetnik


class SovetnikLandingsPackage(SovetnikResource):
    """ A resource that contains tar.gz package with files for Sovetnik's landings service. """
    ttl = 60
    # custom attributes
    git_commit = sdk2.Attributes.String('The last Git commit', required=False)


class SovetnikBackendPackage(SovetnikResource):
    """ A resource that contains `tar.gz` package with files for Sovetnik's backend service. """
    ttl = 60
    # custom attributes
    git_commit = sdk2.Attributes.String('The last Git commit', required=False)


class SovetnikStaticDevPackage(SovetnikResource):
    """ A resource that contains tar.gz package with files for Sovetnik's static development service. """
    releasable = False
    ttl = 60


class SovetnikRedirPackage(SovetnikResource):
    """ A resource that contains tar.gz package with files for Sovetnik's redir service. """
    ttl = 60
    # custom attributes
    version = sdk2.Attributes.String('The package version', required=True)
    git_commit = sdk2.Attributes.String('The last Git commit', required=False)


class SovetnikVendorsPackage(SovetnikResource):
    """ A resource that contains tar.gz package with files with Sovetnik's vendors. """
    ttl = 5
    # custom attributes
    vendor_hash = sdk2.Attributes.String('The hash of dependencies list', required=True)


class SovetnikSelectors(SovetnikResource):
    """ A resource that contains Sovetnik's selectors. """
    releasable = False
    ttl = 5


class SovetnikIznankaSelectors(SovetnikResource):
    """ A resource that contains Sovetnik's selectors for Iznanka. """
    releasable = False
    ttl = 5


class SovetnikYaBrowserSelectors(SovetnikResource):
    """ A resource that contains Sovetnik's selectors for Yandex Browser. """
    releasable = False
    ttl = 5


class MarketSovetnikDomainsConfig(SovetnikResource):
    """Market Sovetnik domains configs"""


class SovetnikScriptTypes:
    NODE_MODULES_CACHE = 'node_modules_cache_script'

    def __init__(self):
        self.owner = 'Sovetnik'


class SovetnikScript(SovetnikResource):
    ttl = 60
    script_type = sdk2.Attributes.String('Script type', required=True, default=SovetnikScriptTypes.NODE_MODULES_CACHE)


class SovetnikExternalResource(SovetnikResource):
    ttl = 60
    resource_type = sdk2.Attributes.String('Resource type', required=True)


class SovetnikGeodataResource(SovetnikResource):
    ttl = 5
    resource_type = 'Geodata'


class SovetnikCurrencyResource(SovetnikResource):
    ttl = 5
    resource_type = 'Currency'


class SovetnikPbuilderImage(sdk2.Resource):
    """The result of pbuilder --create"""


class SovetnikMobileUCPackage(SovetnikResource):
    """ Resource that contains scripts for UC-mobile """
    ttl = 60


class SovetnikMobileYabroPackage(SovetnikResource):
    """ Resource that contains script for YAbro """
    ttl = 60


class SovetnikMobileSmartSearchIphonePackage(SovetnikResource):
    """ Resource that contains script for smartsearch for iphone"""
    ttl = 60


class SovetnikMobileSmartSearchAndroidPackage(SovetnikResource):
    """ Resource that contains script for smartsearch for android"""
    ttl = 60


class SovetnikSettingsPagePackage(SovetnikResource):
    """ A resource that contains tar.gz package with files for Sovetnik's setting page for desktop service. """
    ttl = 60


class SovetnikMobileSettingsPagePackage(SovetnikResource):
    """ A resource that contains tar.gz package with files for Sovetnik's setting page for mobile service. """
    ttl = 60
