# -*- coding: utf-8 -*-

import os.path
import shutil

from sandbox.projects import resource_types
from sandbox.sandboxsdk.task import SandboxTask
from sandbox.sandboxsdk.paths import make_folder
from sandbox.projects.common.nanny import nanny
from sandbox.projects.common.BaseReportShardTask import getClassesByResources


class StabilizeNewsAppHostSrcSetupProductionLoopConf(nanny.ReleaseToNannyTask, SandboxTask):
    """
        Сохраняет в себе ту версию APP_HOST_SRC_SETUP_PRODUCTION_LOOP_CONF, которая проверена и одобрена Новостями
    """
    type = 'STABILIZE_NEWS_APP_HOST_SRC_SETUP_PRODUCTION_LOOP_CONF'

    input_parameters = getClassesByResources(['APP_HOST_SRC_SETUP_PRODUCTION_LOOP_CONF'])

    def on_execute(self):
        workcopy_dir = self.abs_path('workcopy')
        make_folder(workcopy_dir)
        os.chdir(workcopy_dir)

        path = self.sync_resource(self.ctx.get('res_app_host_src_setup_production_loop_conf'))

        shutil.copy(path, '.')

        resource = self.create_resource(
            description=self.descr,
            resource_path="workcopy/" + os.path.basename(path),
            resource_type=resource_types.STABLE_NEWS_APP_HOST_SRC_SETUP_PRODUCTION_LOOP_CONF,
            arch=self.arch
        )

        self.mark_resource_ready(resource.id)

    def on_release(self, rest):
        nanny.ReleaseToNannyTask.on_release(self, rest)
        SandboxTask.on_release(self, rest)


__Task__ = StabilizeNewsAppHostSrcSetupProductionLoopConf
