from sandbox import sdk2


class STATBOX_REVISOR_CHECKOUT(sdk2.Resource):
    """Trick for release function in STATBOX_TICKET_TO_STABLE"""
    releasable = True


class STATBOX_PBUILDER_IMAGE(sdk2.Resource):
    """The result of pbuilder --create"""


class STATBOX_PBUILDER_HOOKS(sdk2.Resource):
    """Hooks for Statbox pbuilder"""


class STATBOX_PBUILDER_APTCACHE(sdk2.Resource):
    """Apt cache used by pbuilder (STATBOX_DEBUILDER)"""


class STATBOX_DEB_PACKAGE(sdk2.Resource):
    """Deb file built by STATBOX_DEBUILDER"""
    releasable = True
    releasers = ['shprot', 'hans', 'thenno', 'seray', 'ivanovvlad', 'monory', 'dalamar']


class STATBOX_LIBRA_YMAKE(sdk2.Resource):
    """local.ymake for libra.so build"""
    releasers = ['shprot', 'hans', 'dmifedorov', 'thenno']
    ttl = "inf"


class STATBOX_BAOBAB_YMAKE(sdk2.Resource):
    """local.ymake for baobab.so build"""
    releasers = ['shprot', 'hans', 'dmifedorov', 'thenno']
    ttl = "inf"


class STATBOX_TOXIC_LXC(sdk2.service_resources.LxcContainer):
    """LXC container with tox installed (for STATBOX_TOXIC tasks)"""
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    releasers = ['shprot', 'hans', 'dmifedorov', 'thenno', 'lipkin']
    ttl = "inf"


class STATBOX_RELOOSER_LXC(sdk2.service_resources.LxcContainer):
    """LXC container with releaser installed (for STATBOX_RELOOSER tasks)"""
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    releasers = ['shprot', 'hans', 'dmifedorov', 'thenno', 'hhell']
    ttl = "inf"


class STATFACE_TASK_RUNNER_LXC(sdk2.service_resources.LxcContainer):
    """LXC container with docker installed (for STATFACE_TASK_RUNNER tasks)"""
    __default_attribute__ = sdk2.parameters.String

    releasable = True
    releasers = ['shprot', 'hans', 'asnytin', 'hhell']
    ttl = "inf"
