# -*- coding: utf-8 -*-
import logging

from sandbox import sdk2
from sandbox.projects.StationUI.WPR import StationuiWPR


class StationuiPlayWPR(StationuiWPR):
    """ Запуск wpr на станции """

    MEASURE_BUILD_TYPE_ID = 'Browser_Tests_Perf_Measure_MeasureNoWait'
    MEASURE_PRODUCT = 'web-pages-teamcity'

    class Parameters(sdk2.Task.Parameters):

        spec_id = sdk2.parameters.String("Номер teamcity задачи с записью wpr", required=True)
        repeat = sdk2.parameters.Integer("Количество повторений воспроизведения", required=True, default=5)

        browser_teamcity_vault = sdk2.parameters.String(
            'Vault item with token for browser teamcity',
            default='ROBOT_SPEEDY_BROWSER_TEAMCITY')

        with sdk2.parameters.Output():
            build_id = sdk2.parameters.Integer(
                "build_id воспроизведения wpr",
            )

    def log_start(self):
        logging.info("Воспроизведение wpr")
        logging.info("spec_id: " + str(self.Parameters.spec_id))
        logging.info("repeat: " + str(self.Parameters.repeat))

    def get_properties(self):
        return {
            'product': self.MEASURE_PRODUCT,
            'spec': self.Parameters.spec_id,
            'extra_args': '--run-benchmark-arg=--pageset-repeat=' + str(self.Parameters.repeat),
        }
