# -*- coding: utf-8 -*-
import logging

from sandbox import sdk2
from sandbox.projects.browser.perf.record_wpr_archive import WprArchive
from sandbox.projects.StationUI.WPR import StationuiWPR


class StationuiWriteWPR(StationuiWPR):
    """ Запись wpr на станции """

    MEASURE_BUILD_TYPE_ID = 'Browser_Tests_Perf_RecordWPR_RecordWPRArchive'
    MEASURE_PRODUCT = 'quasarapp'

    class Parameters(sdk2.Task.Parameters):
        kill_timeout = 3600

        record_config = sdk2.parameters.String("record_config", multiline=True, required=True)

        browser_teamcity_vault = sdk2.parameters.String(
            'Vault item with token for browser teamcity',
            default='ROBOT_SPEEDY_BROWSER_TEAMCITY')

        snapshot_id = sdk2.parameters.String('Хэш коммита на котором записывается wpr')

        with sdk2.parameters.Output():
            build_id = sdk2.parameters.Integer(
                "build_id записи wpr",
            )

    def log_start(self):
        logging.info("Запись wpr")
        logging.info("record_config\n" + str(self.Parameters.record_config))

    def get_properties(self):
        return {
            'product': self.MEASURE_PRODUCT,
            'record_config': self.Parameters.record_config
        }

    def get_resource(self, build_id):
        path = 'wpr_archive.tar'
        self.download_results(build_id, path, path)

        return WprArchive(
            self, 'TeamCity wpr_archive', path,
            product=self.MEASURE_PRODUCT,
            snapshot_id=self.Parameters.snapshot_id or 'production')
