# coding=utf-8

from sandbox.projects.Strm.StrmBuildClickhouseDictionary.common import StrmBuildClickhouseDictionaryBase
from sandbox.projects.Strm.StrmBuildClickhouseDictionary.utils import stream_decompress_response_gzip


class StrmBuildClickhouseDictionaryASName(StrmBuildClickhouseDictionaryBase):
    """
    Build Clickhouse dictionary from as-name and upload it to S3
    """

    class Parameters(StrmBuildClickhouseDictionaryBase.Parameters):
        dictionary_name = StrmBuildClickhouseDictionaryBase.Parameters.dictionary_name(default="as_name")
        output_name = StrmBuildClickhouseDictionaryBase.Parameters.output_name(default="as_name.csv")
        source_url = StrmBuildClickhouseDictionaryBase.Parameters.source_url(
            default="https://proxy.sandbox.yandex-team.ru/last/IPREG_EXPORT/as-name.gz"
        )

    @staticmethod
    def decode_chunks_to_lines(chunks):
        decode_to_lines = StrmBuildClickhouseDictionaryBase.decode_chunks_to_lines

        chunks = stream_decompress_response_gzip(chunks)
        return decode_to_lines(chunks)

    @staticmethod
    def parse_lines(lines):
        for line in lines:
            line = line.strip().split("\t")

            asn, name, desc = line[0], line[1], ""

            if len(line) >= 3:
                desc = line[2]

            asn = asn.upper().lstrip("AS")
            asn = int(asn)

            yield asn, name, desc
