# coding=utf-8

from sandbox.projects.Strm.StrmBuildClickhouseDictionary.common import StrmBuildClickhouseDictionaryBase
from sandbox.projects.Strm.StrmBuildClickhouseDictionary.utils import stream_decompress_response_gzip


class StrmBuildClickhouseDictionaryIPOrigin(StrmBuildClickhouseDictionaryBase):
    """
    Build Clickhouse dictionary from ip_origin and upload it to S3
    """

    class Parameters(StrmBuildClickhouseDictionaryBase.Parameters):
        dictionary_name = StrmBuildClickhouseDictionaryBase.Parameters.dictionary_name(default="ip_origin")
        output_name = StrmBuildClickhouseDictionaryBase.Parameters.output_name(
            default="ip_origin.csv",
        )

        source_url = StrmBuildClickhouseDictionaryBase.Parameters.source_url(
            default="https://proxy.sandbox.yandex-team.ru/last/IPREG_EXPORT/IPv6/ip_origin.gz",
        )

    @staticmethod
    def decode_chunks_to_lines(chunks):
        decode_to_lines = StrmBuildClickhouseDictionaryBase.decode_chunks_to_lines

        chunks = stream_decompress_response_gzip(chunks)
        return decode_to_lines(chunks)

    @staticmethod
    def parse_lines(lines):
        import netaddr

        for line in lines:
            line = line.strip().split()

            range_start, range_end = line[0].split("-")
            ip_range = netaddr.IPRange(range_start, range_end)

            asn = line[1]
            asn = asn.upper().lstrip("AS")
            asn = int(asn)

            for cidr in ip_range.cidrs():
                yield cidr, asn
