# coding=utf-8

import logging
import tempfile

from sandbox.projects.Strm.StrmBuildClickhouseDictionary.common import StrmBuildClickhouseDictionaryBase


class StrmBuildClickhouseDictionaryIPREG(StrmBuildClickhouseDictionaryBase):
    """
    Build Clickhouse dictionary from IPREG and upload it to S3
    """

    class Parameters(StrmBuildClickhouseDictionaryBase.Parameters):
        kill_timeout = 1800

        dictionary_name = StrmBuildClickhouseDictionaryBase.Parameters.dictionary_name(default="ipreg")
        output_name = StrmBuildClickhouseDictionaryBase.Parameters.output_name(
            default="IPREG.csv",
        )

        source_url = StrmBuildClickhouseDictionaryBase.Parameters.source_url(
            default="https://proxy.sandbox.yandex-team.ru/last/IPREG_EXPORT/IPv6/IPREG.detailed",
        )

    @staticmethod
    def parse_lines(lines):
        import netaddr

        # Source file is large and processing is slow, so better to work on local copy
        with tempfile.NamedTemporaryFile("w+") as tmp:
            tmp.writelines(line + "\n" for line in lines)

            tmp.flush()
            tmp.seek(0)

            logging.info("Source file saved to temp")

            for line in tmp:
                range_start, range_end, region_id = line.strip().split()
                ip_range = netaddr.IPRange(range_start, range_end)

                for cidr in ip_range.cidrs():
                    yield cidr, region_id
