# coding=utf-8

import json

import six

from sandbox.projects.Strm.StrmBuildClickhouseDictionary.common import StrmBuildClickhouseDictionaryBase


class StrmBuildClickhouseDictionaryRDRMetrics(StrmBuildClickhouseDictionaryBase):
    """
    Build Clickhouse dictionary from RDR API /metrics and upload it to S3
    """

    class Parameters(StrmBuildClickhouseDictionaryBase.Parameters):
        dictionary_name = StrmBuildClickhouseDictionaryBase.Parameters.dictionary_name(default="rdr_metrics")
        output_name = StrmBuildClickhouseDictionaryBase.Parameters.output_name(
            default="rdr_metrics.csv",
        )

        source_url = StrmBuildClickhouseDictionaryBase.Parameters.source_url(
            default="https://rdr.tt.yandex.net/api/v3.0.2/metrics",
        )

        check_last_modified = None

    @staticmethod
    def parse_lines(lines):
        data = json.loads("\n".join(lines))
        links = dict()

        for link in data["links"]:
            links[link["identifier"]] = (
                link["host"],
                link["ifname"],
                int(link["internal"]),
                link["load"],
                link["location"],
                link["provider"],
                link["speed"],
                link["uplink_load"] or 0,
                link["uplink_speed"] or 0,
                int(link.get("drain", False)),
            )

        for link_id, metrics in six.iteritems(links):
            yield [link_id] + list(metrics)
