# coding=utf-8

import json
from collections import defaultdict

import six

from sandbox.projects.Strm.StrmBuildClickhouseDictionary.common import StrmBuildClickhouseDictionaryBase


class StrmBuildClickhouseDictionaryRDRPrefixes(StrmBuildClickhouseDictionaryBase):
    """
    Build Clickhouse dictionary from RDR API /prefixes and upload it to S3
    """

    class Parameters(StrmBuildClickhouseDictionaryBase.Parameters):
        dictionary_name = StrmBuildClickhouseDictionaryBase.Parameters.dictionary_name(default="rdr_prefixes")
        output_name = StrmBuildClickhouseDictionaryBase.Parameters.output_name(
            default="rdr_prefixes.csv",
        )

        source_url = StrmBuildClickhouseDictionaryBase.Parameters.source_url(
            default="http://gorshok.strm.yandex.net/prefixes/rum_bgp",
        )

        check_last_modified = None

    @staticmethod
    def parse_lines(lines):
        import netaddr

        prefixes_out = defaultdict(set)
        prefixes = json.loads("\n".join(lines))

        for prefix, links in six.iteritems(prefixes):
            prefix_v6 = str(netaddr.IPNetwork(prefix).ipv6())
            links_str = ";".join(map(str, links.keys()))

            yield prefix_v6, links_str, prefix
