import codecs
import zlib


class SourceNotModified(Exception):
    pass


def stream_decompress_response_gzip(iterator):
    """
    Decompress gzip compressed iterator.
    """

    decompressor = zlib.decompressobj(zlib.MAX_WBITS | 16)

    for chunk in iterator:
        rv = decompressor.decompress(chunk)
        if rv:
            yield rv

    rv = decompressor.flush()
    if rv:
        yield rv


def stream_decode_response_unicode(iterator):
    """
    Stream decodes a iterator.
    """

    decoder = codecs.getincrementaldecoder("UTF-8")(errors="replace")

    for chunk in iterator:
        rv = decoder.decode(chunk)
        if rv:
            yield rv

    rv = decoder.decode(b"", final=True)
    if rv:
        yield rv
