DECLARE $start_date AS String;
DECLARE $maximum_cache_size AS Uint64;

PRAGMA yt.Pool = "strm";
PRAGMA yt.PoolTrees = "physical";
PRAGMA yt.UseDefaultTentativePoolTrees;
PRAGMA yt.TemporaryAutoMerge = "disabled";

$aggregated_size = (
    SELECT
        content_id,
        clean_uri,
        SUM(traffic) AS traffic,
        MAX(size) AS size,
        MAX(uri_max_ts) AS uri_max_ts,
        MIN(uri_min_ts) AS uri_min_ts
    FROM RANGE(`//home/strm/vod_top/1h`, $start_date)
    GROUP BY content_id, clean_uri
);

$aggregated_information = (
    SELECT
        cache_hit,
        content_id AS content,
        size,
        (SUM(size) OVER w) AS accumulated_size,
        window_duration
    FROM (
        SELECT
            SUM(traffic) / SUM(size) AS cache_hit,
            content_id,
            SUM(size) AS size,
            (MAX(uri_max_ts) - MIN(uri_min_ts)) * 1000 as window_duration
        FROM $aggregated_size
        GROUP BY content_id
        HAVING SUM(size) > 0
    )
    WINDOW w AS (ORDER BY cache_hit DESC)
);

SELECT
    cache_hit,
    content,
    size,
    window_duration
FROM
    $aggregated_information
WHERE
    accumulated_size <= $maximum_cache_size AND window_duration > 0
ORDER BY cache_hit DESC;
