DECLARE $start_date AS String;

PRAGMA yt.Pool = "strm";
PRAGMA yt.PoolTrees = "physical";
PRAGMA yt.UseDefaultTentativePoolTrees;

SELECT
    SUM(traffic) as traffic,
    SUM_IF(traffic, String::Contains(clean_uri, "/kaltura/")) ?? 0 as kaltura_traffic,
    bucket
FROM hahn.RANGE(`//home/strm/vod_top/1h`, $start_date)
GROUP BY (String::SplitToList(content_id, "/")[1] as bucket)
HAVING bucket != ""
