# -*- coding: utf-8 -*-
import logging
import re

RE_PLAYLIST_GENERIC = re.compile(r"^.*_([0-9]+_[0-9]+p).(?:m3u8|json/index.*\.m3u8)", re.VERBOSE)

logger = logging.getLogger("playlist_util")


def get_min_resolution(session, channel):
    logger.info("Channel name %s", channel)

    raw_url = "http://strm.yandex.ru/kal/{0}/{0}0.m3u8".format(channel)
    resp = session.get(raw_url)
    resp.raise_for_status()

    vertical_resolution = 0
    channel_min_resolution = None
    for line in resp.content.split():
        if line[0] == "#":
            continue

        match = RE_PLAYLIST_GENERIC.match(line)
        if match:
            res = int(match.group(1).split("_")[1][:-1])
            if not vertical_resolution or res < vertical_resolution:
                vertical_resolution = res
                channel_min_resolution = match.group(1)

    logger.info("Min resolution %s for channel %s", channel_min_resolution, channel)
    return channel_min_resolution
