# -*- coding: utf-8 -*-
from collections import defaultdict

CONTENT_TYPES = {
    'ts': 'video/MP2T',
    'm3u8': 'application/x-mpegURL',
    'mp4': 'video/mp4',
    'mkv': 'video/x-matroska',
    'webm': 'video/webm',
    'ogv': 'video/ogg',
    'flv': 'video/x-flv',
    'mpd': 'application/dash+xml',
    'ismc': 'application/vnd.ms-sstr+xml',
    'png': 'image/png',
    'jpg': 'image/jpeg',
    'vtt': 'text/vtt'
}

DEFAULT_RESOLUTIONS = (
    # (key, (width, height, video bitrate, audio bitrate))
    ("169_240p", ("432", "240", "350", "64")),
    ("169_360p", ("640", "360", "700", "64")),
    ("169_480p", ("852", "480", "1200", "64")),
    ("169_576p", ("1024", "576", "2000", "64")),
    ("169_720p", ("1280", "720", "4000", "128")),
    ("169_1080p", ("1920", "1080", "6000", "128")),
    ("169_1440p", ("2560", "1440", "9000", "128")),
    ("169_2160p", ("3840", "2160", "20000", "128")),

    ("43_240p", ("320", "240", "350", "64")),
    ("43_360p", ("480", "360", "500", "64")),
    ("43_480p", ("640", "480", "1000", "64")),
    ("43_576p", ("768", "576", "2000", "128")),
    ("43_720p", ("960", "720", "3000", "128")),
    ("43_1080p", ("1440", "1080", "4200", "128"))
)

# https://st.yandex-team.ru/VH-7492
BANNERSTORAGE_RESOLUTIONS = (
    # QuadHD (16:9)
    ("169_240p", ("426", "240", "500", "64")),
    ("169_360p", ("640", "360", "1000", "64")),
    ("169_480p", ("854", "480", "2500", "64")),
    ("169_720p", ("1280", "720", "5000", "128")),
    ("169_1080p", ("1920", "1080", "8000", "128")),
)

AWAPS_RESOLUTIONS = (
    ("169_1080p", ("1920", "1080", "5000", "128")),
    ("169_720p", ("1280", "720", "3200", "128")),
    ("169_576p", ("1024", "576", "2000", "64")),
    ("169_480p", ("852", "480", "1200", "64")),
    ("169_360p", ("640", "360", "700", "64")),
    ("169_270p", ("480", "270", "500", "64")),

    ("1511_720p", ("980", "720", "3000", "128")),
    ("1511_576p", ("784", "576", "1800", "128")),
    ("1511_240p", ("326", "240", "350", "64")),

    ("43_720p", ("960", "720", "3200", "128")),
    ("43_576p", ("768", "576", "2000", "128")),
    ("43_540p", ("720", "540", "1700", "64")),
    ("43_270p", ("360", "270", "450", "64")),
    ("43_240p", ("320", "240", "350", "64")),

    ("54_720p", ("900", "720", "3000", "128")),
    ("54_576p", ("720", "576", "1800", "128")),
    ("54_240p", ("300", "240", "350", "64"))
)

EMBED_BASE_169_HEIGHTS = (1080, 720, 576, 480, 360, 240)
EMBED_ASPECT_RATIOS = ((16, 9), (4, 3), (5, 4), (15, 11), (20, 11))
EMBED_INPUT_RESOLUTIONS = (
    ("43_540p", (720, 540)),
)

AWAPS_BASELINE_LEVELS = defaultdict(lambda: '-1')
AWAPS_BASELINE_LEVELS['43_240p'] = '1.3'    # SPS 6742c00dd90141fb011000000300100000030320f142a480
AWAPS_BASELINE_LEVELS['43_576p'] = '3.1'    # SPS 6742c01fd900c0126c0440000003004000000c83c60c92
AWAPS_BASELINE_LEVELS['43_720p'] = '3.1'    # SPS

AWAPS_BASELINE_LEVELS['1511_240p'] = '1.3'    # SPS
AWAPS_BASELINE_LEVELS['1511_576p'] = '3.1'    # SPS
AWAPS_BASELINE_LEVELS['1511_720p'] = '3.1'    # SPS

AWAPS_BASELINE_LEVELS['54_240p'] = '1.3'    # SPS
AWAPS_BASELINE_LEVELS['54_576p'] = '3.0'    # SPS
AWAPS_BASELINE_LEVELS['54_720p'] = '3.1'    # SPS

AWAPS_BASELINE_LEVELS['169_270p'] = '2.1'   # SPS 6742c015d901e08feb011000000300100000030320f162e480
AWAPS_BASELINE_LEVELS['169_360p'] = '3.0'   # SPS 6742c01ed900a02ff97011000003000100000300320f162e48
AWAPS_BASELINE_LEVELS['169_480p'] = '3.0'   # SPS 6742c01ed900d83de7f011000003000100000300320f162e48
AWAPS_BASELINE_LEVELS['169_576p'] = '3.1'   # SPS 6742c01fd90040049b011000000300100000030320f1832480
AWAPS_BASELINE_LEVELS['169_720p'] = '3.1'   # SPS 6742c01fd9005005bb011000000300100000030320f1832480
AWAPS_BASELINE_LEVELS['169_1080p'] = '4.0'  # SPS 6742c028d900780227e5c044000003000400000300c83c60c920

OTT_RESOLUTIONS = (
    ("169_1080p", ("1920", "1080", "5000", "128", "hd")),
    ("169_720p", ("1280", "720", "3000", "128", "hd")),
    ("169_576p", ("1024", "576", "2000", "64", "sd")),
    ("169_432p", ("768", "432", "1000", "64", "sd")),
    ("169_360p", ("640", "360", "400", "64", "sd")),

    ("43_1080p", ("1440", "1080", "5000", "128", "hd")),
    ("43_720p", ("960", "720", "3200", "128", "hd")),
    ("43_576p", ("768", "576", "2000", "64", "sd")),
    ("43_480p", ("640", "480", "1200", "64", "sd")),
    ("43_270p", ("360", "270", "450", "64", "sd"))
)

BROWSER_RESOLUTIONS = (
    ("169_1440p", ("2560", "1440", "15000", "128")),
    ("169_1080p", ("1920", "1080", "10000", "128")),
    ("169_768p",  ("1366", "768", "5000", "128")),
)

QUALITY_CRF = {
    'ultrafast': 30,
    'superfast': 26,
    'veryfast': 22,
    'faster': 18,
    'fast': 14,
    'medium': 10,
    'slow': 8,
    'slower': 7,
    'veryslow': 5,
    'placebo': 4
}

QUALITY_VP9_CRF = {
    'ultrafast': 61,
    'superfast': 56,
    'veryfast': 50,
    'faster': 43,
    'fast': 37,
    'medium': 31,
    'slow': 25,
    'slower': 19,
    'veryslow': 15,
    'placebo': 10
}
QUALITY_SCALE = {
    'ultrafast': 0,
    'superfast': 1,
    'veryfast': 2,
    'faster': 3,
    'fast': 4,
    'medium': 5,
    'slow': 6,
    'slower': 7,
    'veryslow': 8,
    'placebo': 9
}

YOUTUBE_DL_DOMAINS = [
    'youtube.com',
    'youtu.be',
    'twitter.com',
    'facebook.com',
    'tv.naver.com',
    'yahoo.com',
    'imdb.com',
    'allocine.fr',
    'vimeo.com'
]
# https://st.yandex-team.ru/VH-6828
# Пока python skynet не обновиться до 2.7.9
YOUTUBE_DL_DOMAINS_SNI_REQUIRED = [
    'imdb.com'
]
