# -*- coding: utf-8 -*-

import aes
import struct
import hashlib
import xml.sax.saxutils as saxutils

PLAYREADY_TESTING_KEYSEED = "XVBovsmzhP9gRIZxWfFta3VVRPzVEWmJsazEJ46I"


def swap_key(kid):
    return kid[3]+kid[2]+kid[1]+kid[0]+kid[5]+kid[4]+kid[7]+kid[6]+kid[8:]


def derive_key(seed, kid, swap=True):
    if len(seed) < 30:
        raise Exception('seed must be  >= 30 bytes')
    if len(kid) != 16:
        raise Exception('kid must be 16 bytes')

    if swap:
        kid = swap_key(kid)

    seed = seed[:30]

    sha = hashlib.sha256()
    sha.update(seed)
    sha.update(kid)
    sha_A = [ord(x) for x in sha.digest()]

    sha = hashlib.sha256()
    sha.update(seed)
    sha.update(kid)
    sha.update(seed)
    sha_B = [ord(x) for x in sha.digest()]

    sha = hashlib.sha256()
    sha.update(seed)
    sha.update(kid)
    sha.update(seed)
    sha.update(kid)
    sha_C = [ord(x) for x in sha.digest()]

    content_key = ""
    for i in range(16):
        content_key += chr(sha_A[i] ^ sha_A[i+16] ^ sha_B[i] ^ sha_B[i+16] ^ sha_C[i] ^ sha_C[i+16])

    return content_key


def checksum(kid, key):
    return aes.rijndael(key).encrypt(kid)[:8]


def wrap_header_xml(header_xml):
    header_utf16_le = header_xml.encode('utf-16-le')
    rm_record = struct.pack('<HH', 1, len(header_utf16_le))+header_utf16_le
    return struct.pack('<IH', len(rm_record)+6, 1)+rm_record


def generate_header40(header_spec, kid_hex, key_hex):
    try:
        pairs = header_spec.split('#')
        fields = {}
        for pair in pairs:
            if len(pair) == 0: continue
            name, value = pair.split(':', 1)
            fields[name] = value
    except:
        raise Exception('invalid header spec')

    header_xml = '<WRMHEADER xmlns="http://schemas.microsoft.com/DRM/2007/03/PlayReadyHeader" version="4.0.0.0"><DATA><PROTECTINFO><KEYLEN>16</KEYLEN><ALGID>AESCTR</ALGID></PROTECTINFO>'

    kid = kid_hex.decode('hex')
    kid = swap_key(kid)
    header_xml += '<KID>'+kid.encode('base64').replace('\n', '')+'</KID>'
    if key_hex:
        header_xml += '<CHECKSUM>'+checksum(kid, key_hex.decode('hex')).encode('base64').replace('\n', '')+'</CHECKSUM>'

    if 'LA_URL' in fields:
        header_xml += '<LA_URL>'+saxutils.escape(fields['LA_URL'])+'</LA_URL>'
    if 'LUI_URL' in fields:
        header_xml += '<LUI_URL>'+saxutils.escape(fields['LUI_URL'])+'</LUI_URL>'
    if 'DS_ID' in fields:
        header_xml += '<DS_ID>'+saxutils.escape(fields['DS_ID'])+'</DS_ID>'
    if 'CUSTOMATTRIBUTES' in fields:
        header_xml += '<CUSTOMATTRIBUTES>'+fields['CUSTOMATTRIBUTES'].decode('base64').replace('\n', '')+'</CUSTOMATTRIBUTES>'

    header_xml += '</DATA></WRMHEADER>'
    return wrap_header_xml(header_xml)


def generate_header41(header_spec, kid_hex, key_hex):
    try:
        pairs = header_spec.split('#')
        fields = {}
        for pair in pairs:
            if len(pair) == 0: continue
            name, value = pair.split(':', 1)
            fields[name] = value
    except:
        raise Exception('invalid header spec')

    header_xml = '<WRMHEADER xmlns="http://schemas.microsoft.com/DRM/2007/03/PlayReadyHeader" version="4.1.0.0"><DATA><PROTECTINFO>'

    kid = kid_hex.decode('hex')
    kid = swap_key(kid)
    header_xml += '<KID ALGID="AESCTR" CHECKSUM="' + checksum(kid, key_hex.decode('hex')).encode('base64').replace('\n', '') + '" VALUE="' + kid.encode('base64').replace('\n', '') + '" /></PROTECTINFO>'

    if 'CUSTOMATTRIBUTES' in fields:
        header_xml += '<CUSTOMATTRIBUTES>'+fields['CUSTOMATTRIBUTES'].decode('base64').replace('\n', '')+'</CUSTOMATTRIBUTES>'
    if 'LA_URL' in fields:
        header_xml += '<LA_URL>'+saxutils.escape(fields['LA_URL'])+'</LA_URL>'
    if 'LUI_URL' in fields:
        header_xml += '<LUI_URL>'+saxutils.escape(fields['LUI_URL'])+'</LUI_URL>'
    if 'DS_ID' in fields:
        header_xml += '<DS_ID>'+saxutils.escape(fields['DS_ID'])+'</DS_ID>'

    header_xml += '</DATA></WRMHEADER>'
    return wrap_header_xml(header_xml)


def generate_header42(header_spec, keys):
    try:
        pairs = header_spec.split('#')
        fields = {}
        for pair in pairs:
            if len(pair) == 0: continue
            name, value = pair.split(':', 1)
            fields[name] = value
    except:
        raise Exception('invalid header spec')

    header_xml = '<WRMHEADER xmlns="http://schemas.microsoft.com/DRM/2007/03/PlayReadyHeader" version="4.2.0.0"><DATA><PROTECTINFO><KIDS>'

    for (kid, key) in keys:
        header_xml += '<KID ALGID="AESCTR" CHECKSUM="{}" VALUE="{}"></KID>'\
            .format(checksum(swap_key(kid.decode('hex')), key.decode('hex')).encode('base64').replace('\n', ''),
                    swap_key(kid.decode('hex')).encode('base64').replace('\n', ''))

    header_xml += '</KIDS></PROTECTINFO>'

    if 'LA_URL' in fields:
        header_xml += '<LA_URL>'+saxutils.escape(fields['LA_URL'])+'</LA_URL>'
    if 'LUI_URL' in fields:
        header_xml += '<LUI_URL>'+saxutils.escape(fields['LUI_URL'])+'</LUI_URL>'
    if 'DS_ID' in fields:
        header_xml += '<DS_ID>'+saxutils.escape(fields['DS_ID'])+'</DS_ID>'
    if 'CUSTOMATTRIBUTES' in fields:
        header_xml += '<CUSTOMATTRIBUTES>' + fields['CUSTOMATTRIBUTES'].decode('base64').replace('\n', '') + '</CUSTOMATTRIBUTES>'

    header_xml += '</DATA></WRMHEADER>'

    return wrap_header_xml(header_xml)
