class Channel:
    _SRC_ADDRESS_TPL = '{protocol}://{src}:{port}/{channel}/{channel}0'

    def __init__(self, name, src_addresses):
        self.name = name
        self.src_addresses = src_addresses

    @classmethod
    def get_channel(cls, channel_name, config_provider, conductor):
        try:
            channel_config = config_provider.get_channel_cfg(channel_name)
        except Exception as e:
            raise RuntimeError('Unable to get channel config: {reason}'.format(reason=e.message))

        src_addresses = []
        for src_group_name in channel_config.src_groups_names:
            try:
                src_names = conductor.get_hosts(src_group_name)
            except Exception as e:
                raise RuntimeError('Unable to get src names: {reason}'.format(reason=e.message))

            for src_name in src_names:
                protocol = 'tcp'
                if 'rtmp' in src_name:
                    protocol = 'rtmp'
                src_address = cls._SRC_ADDRESS_TPL.format(
                    protocol=protocol,
                    src=src_name,
                    port=channel_config.port,
                    channel=channel_name,
                )
                src_addresses.append(src_address)

        if not src_addresses:
            raise ValueError('No source addresses found')

        return Channel(channel_name, src_addresses)
